/*
 * Decompiled with CFR 0.152.
 */
package org.basex.server;

import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import org.basex.BaseXServer;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.CommandParser;
import org.basex.core.Context;
import org.basex.core.MainProp;
import org.basex.core.Text;
import org.basex.core.User;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Exit;
import org.basex.core.cmd.Replace;
import org.basex.core.cmd.Store;
import org.basex.io.in.BufferInput;
import org.basex.io.in.DecodingInput;
import org.basex.io.out.EncodingOutput;
import org.basex.io.out.PrintOutput;
import org.basex.query.QueryException;
import org.basex.server.ClientDelayer;
import org.basex.server.Log;
import org.basex.server.QueryListener;
import org.basex.server.ServerCmd;
import org.basex.server.Sessions;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.ByteList;

public final class ClientListener
extends Thread {
    private final HashMap<String, QueryListener> queries = new HashMap();
    private final Performance perf = new Performance();
    private final Context context;
    private final Socket socket;
    private final BaseXServer server;
    private final Log log;
    private Socket esocket;
    private PrintOutput eout;
    private boolean events;
    private BufferInput in;
    private PrintOutput out;
    private Command command;
    private int id;
    private boolean running;
    public long last;

    public ClientListener(Socket s, Context c, Log l, BaseXServer srv) {
        this.context = new Context(c, this);
        this.socket = s;
        this.log = l;
        this.server = srv;
        this.last = System.currentTimeMillis();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block23: {
            try {
                String ts = Long.toString(System.nanoTime());
                byte[] address = this.socket.getInetAddress().getAddress();
                this.out = PrintOutput.get(this.socket.getOutputStream());
                this.out.print(ts);
                this.send(true);
                this.in = new BufferInput(this.socket.getInputStream());
                String us = this.in.readString();
                String pw = this.in.readString();
                this.context.user = this.context.users.get(us);
                boolean bl = this.running = this.context.user != null && Token.md5(String.valueOf(Token.string(this.context.user.password)) + ts).equals(pw);
                if (this.running) {
                    this.log.write(this, "LOGIN " + this.context.user.name, "OK");
                    this.send(true);
                    this.server.unblock(address);
                    this.context.add(this);
                    break block23;
                }
                if (!us.isEmpty()) {
                    this.log.write(this, String.valueOf(Text.SERVERDENIED) + ": " + us);
                    new ClientDelayer(this.server.block(address), this, this.server);
                }
            }
            catch (IOException ex) {
                Util.stack(ex);
                this.log.write(ex.getMessage());
            }
        }
        ServerCmd sc = null;
        Object cmd = null;
        try {
            while (true) {
                String info;
                boolean ok;
                block25: {
                    block24: {
                        if (!this.running) {
                            return;
                        }
                        try {
                            int b = this.in.read();
                            if (b == -1) {
                                this.exit();
                                return;
                            }
                            this.last = System.currentTimeMillis();
                            this.perf.getTime();
                            sc = ServerCmd.get(b);
                            cmd = null;
                            if (sc == ServerCmd.CREATE) {
                                this.create();
                                break block24;
                            }
                            if (sc == ServerCmd.ADD) {
                                this.add();
                                break block24;
                            }
                            if (sc == ServerCmd.WATCH) {
                                this.watch();
                                break block24;
                            }
                            if (sc == ServerCmd.UNWATCH) {
                                this.unwatch();
                                break block24;
                            }
                            if (sc == ServerCmd.REPLACE) {
                                this.replace();
                                break block24;
                            }
                            if (sc == ServerCmd.STORE) {
                                this.store();
                                break block24;
                            }
                            if (sc != ServerCmd.COMMAND) {
                                this.query(sc);
                            } else {
                                cmd = new ByteList().add(b).add(this.in.readBytes()).toString();
                            }
                        }
                        catch (IOException ex) {
                            this.exit();
                            return;
                        }
                    }
                    if (sc != ServerCmd.COMMAND) continue;
                    this.command = null;
                    try {
                        this.command = new CommandParser((String)cmd, this.context).parseSingle();
                    }
                    catch (QueryException ex) {
                        String msg = ex.getMessage();
                        this.log.write(this, cmd, String.valueOf(Text.INFOERROR) + msg);
                        this.out.write(0);
                        this.out.writeString(msg);
                        this.send(false);
                        continue;
                    }
                    this.command.startTimeout(this.context.mprop.num(MainProp.TIMEOUT));
                    this.log.write(this, this.command.toString().replace('\r', ' ').replace('\n', ' '));
                    ok = true;
                    info = null;
                    try {
                        this.command.execute(this.context, new EncodingOutput(this.out));
                        info = this.command.info();
                    }
                    catch (BaseXException ex) {
                        ok = false;
                        info = ex.getMessage();
                        if (!info.startsWith("Interrupted.")) break block25;
                        info = Text.SERVERTIMEOUT;
                    }
                }
                this.command.stopTimeout();
                this.out.write(0);
                this.info(info, ok);
                if (this.command instanceof Exit) break;
            }
            this.exit();
            return;
        }
        catch (IOException ex) {
            this.log.write(this, sc == ServerCmd.COMMAND ? cmd : sc, String.valueOf(Text.INFOERROR) + ex.getMessage());
            Util.stack(ex);
            this.exit();
        }
    }

    public synchronized void exit() {
        this.running = false;
        this.log.write(this, "LOGOUT " + this.context.user.name, "OK");
        try {
            if (this.events) {
                this.esocket.close();
                for (Sessions s : this.context.events.values()) {
                    s.remove(this);
                }
            }
            new Close().execute(this.context);
            if (this.command != null) {
                this.command.stop();
            }
            this.context.delete(this);
            this.socket.close();
        }
        catch (Exception ex) {
            this.log.write(ex.getMessage());
            Util.stack(ex);
        }
    }

    public User user() {
        return this.context.user;
    }

    public synchronized void register(Socket s) throws IOException {
        this.esocket = s;
        this.eout = PrintOutput.get(s.getOutputStream());
        this.eout.write(0);
        this.eout.flush();
    }

    public synchronized void notify(byte[] name, byte[] msg) throws IOException {
        this.last = System.currentTimeMillis();
        this.eout.print(name);
        this.eout.write(0);
        this.eout.print(msg);
        this.eout.write(0);
        this.eout.flush();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append(this.socket.getInetAddress().getHostAddress());
        sb.append(":").append(this.socket.getPort()).append(']');
        if (this.context.data() != null) {
            sb.append(": ").append(this.context.data().meta.name);
        }
        return sb.toString();
    }

    private void error(String info) throws IOException {
        this.info(info, false);
    }

    private void success(String info) throws IOException {
        this.info(info, true);
    }

    private void info(String info, boolean ok) throws IOException {
        this.log.write(this, ok ? "OK" : String.valueOf(Text.INFOERROR) + info, this.perf);
        this.out.writeString(info);
        this.send(ok);
    }

    private void create() throws IOException {
        this.execute(new CreateDB(this.in.readString()));
    }

    private void add() throws IOException {
        this.execute(new Add(this.in.readString()));
    }

    private void replace() throws IOException {
        this.execute(new Replace(this.in.readString()));
    }

    private void store() throws IOException {
        this.execute(new Store(this.in.readString()));
    }

    private void execute(Command cmd) throws IOException {
        this.log.write(this, cmd + "[...]");
        DecodingInput di = new DecodingInput(this.in);
        try {
            cmd.setInput(di);
            cmd.execute(this.context);
            this.success(cmd.info());
        }
        catch (BaseXException ex) {
            di.flush();
            this.error(ex.getMessage());
        }
    }

    private void watch() throws IOException {
        String name;
        Sessions s;
        if (!this.events) {
            this.out.writeString(Integer.toString(this.context.mprop.num(MainProp.EVENTPORT)));
            this.out.writeString(Long.toString(this.getId()));
            this.out.flush();
            this.events = true;
        }
        boolean ok = (s = (Sessions)this.context.events.get(name = this.in.readString())) != null && !s.contains(this);
        String message = "";
        if (ok) {
            s.add(this);
            message = Text.EVENTWAT;
        } else {
            message = s == null ? Text.EVENTNO : Text.EVENTALR;
        }
        this.info(Util.info(message, name), ok);
    }

    private void unwatch() throws IOException {
        String name = this.in.readString();
        Sessions s = (Sessions)this.context.events.get(name);
        boolean ok = s != null && s.contains(this);
        String message = "";
        if (ok) {
            s.remove(this);
            message = Text.EVENTUNWAT;
        } else {
            message = s == null ? Text.EVENTNO : Text.EVENTNOUW;
        }
        this.info(Util.info(message, name), ok);
        this.out.flush();
    }

    private void query(ServerCmd sc) throws IOException {
        String arg = this.in.readString();
        String err = null;
        try {
            if (sc == ServerCmd.QUERY) {
                String query = arg;
                QueryListener qp = new QueryListener(query, this.context);
                arg = Integer.toString(this.id++);
                this.queries.put(arg, qp);
                this.out.writeString(arg);
                this.log.write(this, (Object)((Object)sc) + "(" + arg + ")", query, "OK");
            } else {
                QueryListener qp = this.queries.get(arg);
                if (qp == null) {
                    if (sc != ServerCmd.CLOSE) {
                        throw new IOException("Unknown Query ID: " + arg);
                    }
                } else if (sc == ServerCmd.BIND) {
                    String key = this.in.readString();
                    String val = this.in.readString();
                    String typ = this.in.readString();
                    qp.bind(key, val, typ);
                    this.log.write(this, (Object)((Object)sc) + "(" + arg + ")", key, val, typ, "OK");
                } else if (sc == ServerCmd.ITER) {
                    qp.execute(true, this.out, true);
                } else if (sc == ServerCmd.EXEC) {
                    qp.execute(false, this.out, true);
                } else if (sc == ServerCmd.INFO) {
                    this.out.print(qp.info());
                } else if (sc == ServerCmd.OPTIONS) {
                    this.out.print(qp.options());
                } else if (sc == ServerCmd.CLOSE) {
                    this.queries.remove(arg);
                } else if (sc == ServerCmd.NEXT) {
                    throw new Exception("Protocol for query iteration is out-of-dated.");
                }
                this.out.write(0);
            }
            this.out.write(0);
            if (sc != ServerCmd.BIND) {
                this.log.write(this, (Object)((Object)sc) + "(" + arg + ")", "OK");
            }
        }
        catch (Exception ex) {
            err = ex.getMessage();
            this.log.write(this, (Object)((Object)sc) + "(" + arg + ")", String.valueOf(Text.INFOERROR) + err);
            this.queries.remove(arg);
        }
        if (err != null) {
            this.out.write(0);
            this.out.write(1);
            this.out.writeString(err);
        }
        this.out.flush();
    }

    void send(boolean ok) throws IOException {
        this.out.write(ok ? 0 : 1);
        this.out.flush();
    }
}

