/*
 * Decompiled with CFR 0.152.
 */
package org.basex.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.MainProp;
import org.basex.io.in.BufferInput;
import org.basex.io.in.DecodingInput;
import org.basex.io.out.EncodingOutput;
import org.basex.io.out.PrintOutput;
import org.basex.server.ClientQuery;
import org.basex.server.EventNotifier;
import org.basex.server.LoginException;
import org.basex.server.ServerCmd;
import org.basex.server.Session;
import org.basex.util.Token;

public final class ClientSession
extends Session {
    final Map<String, EventNotifier> notifiers = Collections.synchronizedMap(new HashMap());
    final PrintOutput sout;
    final InputStream sin;
    private final Socket socket;
    private final String ehost;
    private Socket esocket;

    public ClientSession(Context context, String user, String pass) throws IOException {
        this(context, user, pass, null);
    }

    public ClientSession(Context context, String user, String pass, OutputStream output) throws IOException {
        this(context.mprop.get(MainProp.HOST), context.mprop.num(MainProp.PORT), user, pass, output);
    }

    public ClientSession(String host, int port, String user, String pass) throws IOException {
        this(host, port, user, pass, null);
    }

    public ClientSession(String host, int port, String user, String pass, OutputStream output) throws IOException {
        super(output);
        this.ehost = host;
        this.socket = new Socket();
        this.socket.connect(new InetSocketAddress(host, port), 5000);
        this.sin = this.socket.getInputStream();
        BufferInput bi = new BufferInput(this.sin);
        String ts = bi.readString();
        this.sout = PrintOutput.get(this.socket.getOutputStream());
        this.send(user);
        this.send(Token.md5(String.valueOf(Token.md5(pass)) + ts));
        this.sout.flush();
        if (!this.ok(bi)) {
            throw new LoginException();
        }
    }

    @Override
    public void create(String name, InputStream input) throws IOException {
        this.send(ServerCmd.CREATE, input, name);
    }

    @Override
    public void add(String path, InputStream input) throws IOException {
        this.send(ServerCmd.ADD, input, path);
    }

    @Override
    public void replace(String path, InputStream input) throws IOException {
        this.send(ServerCmd.REPLACE, input, path);
    }

    @Override
    public void store(String path, InputStream input) throws IOException {
        this.send(ServerCmd.STORE, input, path);
    }

    @Override
    public ClientQuery query(String query) throws IOException {
        return new ClientQuery(query, this, this.out);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.esocket != null) {
            this.esocket.close();
        }
        this.socket.close();
    }

    @Override
    protected void execute(String cmd, OutputStream os) throws IOException {
        this.send(cmd);
        this.sout.flush();
        this.receive(os);
    }

    @Override
    protected void execute(Command cmd, OutputStream os) throws IOException {
        this.execute(cmd.toString(), os);
    }

    public void watch(String name, EventNotifier notifier) throws IOException {
        this.sout.write(ServerCmd.WATCH.code);
        if (this.esocket == null) {
            this.sout.flush();
            BufferInput bi = new BufferInput(this.sin);
            int eport = Integer.parseInt(bi.readString());
            this.esocket = new Socket();
            this.esocket.connect(new InetSocketAddress(this.ehost, eport), 5000);
            OutputStream so = this.esocket.getOutputStream();
            so.write(bi.readBytes());
            so.write(0);
            so.flush();
            InputStream is = this.esocket.getInputStream();
            is.read();
            this.listen(is);
        }
        this.send(name);
        this.sout.flush();
        this.receive(null);
        this.notifiers.put(name, notifier);
    }

    public void unwatch(String name) throws IOException {
        this.sout.write(ServerCmd.UNWATCH.code);
        this.send(name);
        this.sout.flush();
        this.receive(null);
        this.notifiers.remove(name);
    }

    private void listen(final InputStream in) {
        new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        BufferInput bi = new BufferInput(in);
                        EventNotifier n = ClientSession.this.notifiers.get(bi.readString());
                        String l = bi.readString();
                        if (n == null) continue;
                        n.notify(l);
                    }
                }
                catch (IOException iOException) {
                    return;
                }
            }
        }.start();
    }

    private void send(InputStream input) throws IOException {
        int b;
        EncodingOutput eo = new EncodingOutput(this.sout);
        while ((b = input.read()) != -1) {
            eo.write(b);
        }
        this.sout.write(0);
        this.sout.flush();
        this.receive(null);
    }

    private void receive(OutputStream os) throws IOException {
        BufferInput bi = new BufferInput(this.sin);
        if (os != null) {
            this.receive(bi, os);
        }
        this.info = bi.readString();
        if (!this.ok(bi)) {
            throw new BaseXException(this.info, new Object[0]);
        }
    }

    boolean ok(BufferInput bi) throws IOException {
        return bi.read() == 0;
    }

    void send(ServerCmd cmd, InputStream input, String ... strings) throws IOException {
        this.sout.write(cmd.code);
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.send(s);
            ++n2;
        }
        this.send(input);
    }

    void receive(BufferInput bi, OutputStream os) throws IOException {
        int b;
        DecodingInput di = new DecodingInput(bi);
        while ((b = di.read()) != -1) {
            os.write(b);
        }
    }

    void send(String s) throws IOException {
        this.sout.write(Token.token(s));
        this.sout.write(0);
    }
}

