/*
 * Decompiled with CFR 0.152.
 */
package org.basex.server;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.Progress;
import org.basex.core.Text;
import org.basex.io.out.EncodingOutput;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerProp;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.item.Item;
import org.basex.query.iter.Iter;
import org.basex.util.Performance;
import org.basex.util.TokenBuilder;

final class QueryListener
extends Progress {
    private final Performance perf = new Performance();
    private final QueryProcessor qp;
    private final Context ctx;
    private String info = "";
    private SerializerProp options;

    QueryListener(String qu, Context c) {
        this.qp = new QueryProcessor(qu, c);
        this.ctx = c;
    }

    void bind(String n, Object o, String t) throws IOException {
        try {
            this.qp.bind(n, o, t);
        }
        catch (QueryException ex) {
            throw new BaseXException(ex);
        }
    }

    String info() {
        return this.info;
    }

    String options() throws IOException {
        this.init();
        return this.options.toString();
    }

    void execute(boolean iter, OutputStream out, boolean enc) throws IOException {
        boolean mon = false;
        try {
            try {
                Item it;
                this.init();
                this.ctx.register(this.qp.ctx.updating);
                mon = true;
                Iter ir = this.qp.iter();
                boolean wrap = !this.options.get(SerializerProp.S_WRAP_PREFIX).isEmpty();
                PrintOutput po = PrintOutput.get(enc ? new EncodingOutput(out) : out);
                if (iter && wrap) {
                    po.write(1);
                }
                Serializer ser = Serializer.get(po, this.options);
                int c = 0;
                while ((it = ir.next()) != null) {
                    if (iter && !wrap) {
                        po.write(1);
                        ser.reset();
                    }
                    ser.openResult();
                    it.serialize(ser);
                    ser.closeResult();
                    if (iter && !wrap) {
                        po.flush();
                        out.write(0);
                    }
                    ++c;
                }
                ser.close();
                if (iter && wrap) {
                    out.write(0);
                }
                int up = this.qp.updates();
                TokenBuilder tb = new TokenBuilder();
                tb.addExt(String.valueOf(Text.QUERYHITS) + "% %" + Text.NL, c, c == 1 ? "Item" : "Items");
                tb.addExt(String.valueOf(Text.QUERYUPDATED) + "% %" + Text.NL, up, up == 1 ? "Item" : "Items");
                tb.addExt(String.valueOf(Text.QUERYTOTAL) + "%", this.perf);
                this.info = tb.toString();
            }
            catch (QueryException ex) {
                throw new BaseXException(ex);
            }
        }
        finally {
            try {
                this.qp.close();
            }
            catch (IOException iOException) {}
            if (mon) {
                this.ctx.unregister(this.qp.ctx.updating);
            }
        }
    }

    private void init() throws IOException {
        if (this.options != null) {
            return;
        }
        try {
            this.qp.parse();
        }
        catch (QueryException ex) {
            throw new BaseXException(ex);
        }
        this.options = this.qp.ctx.serProp(false);
    }
}

