/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Scanner;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.server.LoginException;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.StringList;

public final class Util {
    private static final boolean NOCONSOLE = System.console() == null;
    public static String language = "English";
    public static boolean langkeys;
    public static boolean debug;

    private Util() {
    }

    public static String bug(Throwable ex) {
        TokenBuilder tb = new TokenBuilder("Potential bug? Improper use? Your feedback is welcome:");
        tb.add(Text.NL).add("Contact: ").add(Text.MAIL);
        tb.add(Text.NL).add("Version: ").add("BaseX 7.0 beta");
        tb.add(Text.NL).add("Java: ").add(System.getProperty("java.vendor"));
        tb.add(", ").add(System.getProperty("java.version"));
        tb.add(Text.NL).add("OS: ").add(System.getProperty("os.name"));
        tb.add(", ").add(System.getProperty("os.arch"));
        tb.add(Text.NL).add("Stack Trace: ");
        String[] stringArray = Util.toArray(ex);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            tb.add(Text.NL).add(e);
            ++n2;
        }
        return tb.toString();
    }

    public static RuntimeException notexpected(Object ... ext) {
        TokenBuilder tb = new TokenBuilder("Not expected");
        if (ext.length != 0) {
            tb.addExt(": %", ext);
        }
        throw new RuntimeException(tb.add(46).toString());
    }

    public static RuntimeException notimplemented(Object ... ext) {
        TokenBuilder tb = new TokenBuilder("Not Implemented");
        if (ext.length != 0) {
            tb.addExt(" (%)", ext);
        }
        throw new RuntimeException(tb.add(46).toString());
    }

    public static String name(Object o) {
        return Util.name(o.getClass());
    }

    public static String name(Class<?> o) {
        return o.getSimpleName();
    }

    public static String input() {
        Scanner sc = new Scanner(System.in);
        return sc.hasNextLine() ? sc.nextLine().trim() : "";
    }

    public static String password() {
        if (NOCONSOLE) {
            return Util.input();
        }
        char[] pw = System.console().readPassword();
        return pw != null ? new String(pw) : "";
    }

    public static void outln() {
        Util.out(Text.NL, new Object[0]);
    }

    public static void outln(Object str, Object ... ext) {
        Util.out(str + Text.NL, ext);
    }

    public static void out(Object str, Object ... ext) {
        System.out.print(Util.info(str, ext));
    }

    public static void errln(Object obj, Object ... ext) {
        Util.err((obj instanceof Exception ? Util.message((Exception)obj) : obj) + Text.NL, ext);
    }

    public static void err(String string, Object ... ext) {
        System.err.print(Util.info(string, ext));
    }

    public static String message(Exception ex) {
        Util.debug(ex);
        String msg = ex.getMessage();
        if (ex instanceof BindException) {
            return Text.SERVERBIND;
        }
        if (ex instanceof LoginException) {
            return Text.SERVERDENIED;
        }
        if (ex instanceof ConnectException) {
            return Text.SERVERERROR;
        }
        if (ex instanceof SocketTimeoutException) {
            return Text.SERVERTIMEOUT;
        }
        if (ex instanceof SocketException) {
            return Text.SERVERERROR;
        }
        if (ex instanceof UnknownHostException) {
            return Util.info(Text.SERVERUNKNOWN, msg);
        }
        return msg != null && !msg.isEmpty() ? msg : ex.toString();
    }

    public static boolean debug(Throwable ex) {
        if (debug && ex != null) {
            Util.stack(ex);
        }
        return false;
    }

    public static void debug(Object str, Object ... ext) {
        if (debug) {
            Util.errln(str, ext);
        }
    }

    public static void gc(Performance perf) {
        if (!debug) {
            return;
        }
        Performance.gc(4);
        Util.errln(" " + perf + " (" + Performance.getMem() + ")", new Object[0]);
    }

    public static String info(Object str, Object ... ext) {
        return Token.string(Util.inf(str, ext));
    }

    public static byte[] inf(Object str, Object ... ext) {
        return new TokenBuilder().addExt(str, ext).finish();
    }

    public static void stack(int i) {
        Util.errln("You're here:", new Object[0]);
        Util.stack(new Throwable(), i);
    }

    public static void stack(Throwable th) {
        Util.stack(th, 0);
    }

    private static void stack(Throwable th, int i) {
        String[] stack = Util.toArray(th);
        int l = stack.length;
        if (i > 0 && i < l) {
            l = i;
        }
        int s = 0;
        while (s < l) {
            Util.errln(stack[s], new Object[0]);
            ++s;
        }
    }

    public static String[] toArray(Throwable th) {
        StackTraceElement[] st = th.getStackTrace();
        String[] obj = new String[st.length + 1];
        obj[0] = th.toString();
        int i = 0;
        while (i < st.length) {
            obj[i + 1] = "  " + st[i];
            ++i;
        }
        return obj;
    }

    public static String homeDir() {
        String home;
        String work = System.getProperty("user.dir");
        if (new File(work, ".basex").exists()) {
            return work;
        }
        File f = new File(Util.applicationPath());
        String string = home = f.isFile() ? f.getParent() : f.getPath();
        if (new File(home, ".basex").exists()) {
            return home;
        }
        return System.getProperty("user.home");
    }

    private static String applicationPath() {
        String path = Util.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        TokenBuilder tb = new TokenBuilder();
        int pl = path.length();
        int p = 0;
        while (p < pl) {
            char ch = path.charAt(p);
            if (ch == '%' && p + 2 < pl) {
                tb.addByte((byte)Integer.parseInt(path.substring(p + 1, p + 3), 16));
                p += 2;
            } else {
                tb.add(ch);
            }
            ++p;
        }
        try {
            return new String(tb.finish(), Prop.ENCODING);
        }
        catch (Exception ex) {
            Util.stack(ex);
            return tb.toString();
        }
    }

    public static void start(Class<?> clz, String ... args) {
        String a;
        String[] largs;
        StringList sl = new StringList();
        String[] stringArray = largs = new String[]{"java", "-Xmx" + Runtime.getRuntime().maxMemory(), "-cp", System.getProperty("java.class.path"), clz.getName(), "-D"};
        int n = largs.length;
        int n2 = 0;
        while (n2 < n) {
            a = stringArray[n2];
            sl.add(a);
            ++n2;
        }
        stringArray = args;
        n = args.length;
        n2 = 0;
        while (n2 < n) {
            a = stringArray[n2];
            sl.add(a);
            ++n2;
        }
        try {
            new ProcessBuilder(sl.toArray()).start();
        }
        catch (IOException ex) {
            Util.notexpected(ex);
        }
    }

    public static boolean yes(String string) {
        return Token.eq(string, "yes", "true", "ON", Text.INFOON);
    }

    public static boolean no(String string) {
        return Token.eq(string, "no", "false", "OFF", Text.INFOOFF);
    }

    public static String flag(boolean flag) {
        return flag ? Text.INFOON : Text.INFOOFF;
    }
}

