/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.Collection;
import org.basex.util.ft.FTIterator;
import org.basex.util.ft.Language;
import org.basex.util.ft.StemDir;
import org.basex.util.ft.Stemmer;

final class DictionaryStemmer
extends Stemmer {
    final StemDir dict;

    DictionaryStemmer(StemDir d, FTIterator fti) {
        super(fti);
        this.dict = d;
    }

    @Override
    Stemmer get(Language l, FTIterator fti) {
        return new DictionaryStemmer(this.dict, fti);
    }

    @Override
    protected byte prec() {
        return 20;
    }

    @Override
    Collection<Language> languages() {
        return Language.ALL.values();
    }

    @Override
    protected byte[] stem(byte[] word) {
        return this.dict.stem(word);
    }
}

