/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public class TokenSet
implements Iterable<byte[]> {
    protected static final int CAP = 8;
    protected int size = 1;
    protected byte[][] keys;
    private int[] next;
    private int[] bucket;

    public TokenSet() {
        this.keys = new byte[8][];
        this.next = new int[8];
        this.bucket = new int[8];
    }

    public TokenSet(byte[] ... init) {
        this();
        byte[][] byArray = init;
        int n = init.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] i = byArray[n2];
            this.add(i);
            ++n2;
        }
    }

    public TokenSet(DataInput in) throws IOException {
        this.read(in);
    }

    public final void read(DataInput in) throws IOException {
        this.keys = in.readTokens();
        this.next = in.readNums();
        this.bucket = in.readNums();
        this.size = in.readNum();
    }

    public void write(DataOutput out) throws IOException {
        out.writeTokens(this.keys);
        out.writeNums(this.next);
        out.writeNums(this.bucket);
        out.writeNum(this.size);
    }

    public final int add(byte[] key) {
        if (this.size == this.next.length) {
            this.rehash();
        }
        int p = Token.hash(key) & this.bucket.length - 1;
        int id = this.bucket[p];
        while (id != 0) {
            if (Token.eq(key, this.keys[id])) {
                return -id;
            }
            id = this.next[id];
        }
        this.next[this.size] = this.bucket[p];
        this.keys[this.size] = key;
        this.bucket[p] = this.size;
        return this.size++;
    }

    public final int delete(byte[] key) {
        int p = Token.hash(key) & this.bucket.length - 1;
        int id = this.bucket[p];
        while (id != 0) {
            if (Token.eq(key, this.keys[id])) {
                if (this.bucket[p] == id) {
                    this.bucket[p] = this.next[id];
                } else {
                    this.next[id] = this.next[this.next[id]];
                }
                this.keys[id] = null;
                return id;
            }
            id = this.next[id];
        }
        return 0;
    }

    public final int id(byte[] key) {
        int p = Token.hash(key) & this.bucket.length - 1;
        int id = this.bucket[p];
        while (id != 0) {
            if (Token.eq(key, this.keys[id])) {
                return id;
            }
            id = this.next[id];
        }
        return 0;
    }

    public final byte[] key(int i) {
        return this.keys[i];
    }

    public final byte[][] keys() {
        byte[][] tmp = new byte[this.size()][];
        int i = 1;
        while (i < this.size) {
            tmp[i - 1] = this.keys[i];
            ++i;
        }
        return tmp;
    }

    public final int size() {
        return this.size - 1;
    }

    protected void rehash() {
        int s = this.size << 1;
        int[] tmp = new int[s];
        int l = this.bucket.length;
        int i = 0;
        while (i != l) {
            int id = this.bucket[i];
            while (id != 0) {
                int p = Token.hash(this.keys[id]) & s - 1;
                int nx = this.next[id];
                this.next[id] = tmp[p];
                tmp[p] = id;
                id = nx;
            }
            ++i;
        }
        this.bucket = tmp;
        this.next = Arrays.copyOf(this.next, s);
        byte[][] k = new byte[s][];
        System.arraycopy(this.keys, 0, k, 0, this.size);
        this.keys = k;
    }

    @Override
    public final Iterator<byte[]> iterator() {
        return new Iterator<byte[]>(){
            private int c;

            @Override
            public boolean hasNext() {
                return ++this.c < TokenSet.this.size;
            }

            @Override
            public byte[] next() {
                return TokenSet.this.keys[this.c];
            }

            @Override
            public void remove() {
                Util.notexpected(new Object[0]);
            }
        };
    }

    public String toString() {
        return new TokenBuilder(Util.name(this)).add(91).addSep((Object[])this.keys(), ", ").add(93).toString();
    }
}

