/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import java.util.Iterator;
import java.util.RandomAccess;
import org.basex.util.Array;
import org.basex.util.Util;
import org.basex.util.list.ElementList;

public final class ObjList<E>
extends ElementList
implements Iterable<E>,
RandomAccess {
    Object[] list;

    public ObjList() {
        this(8);
    }

    public ObjList(int c) {
        this.list = new Object[c];
    }

    public void add(E e) {
        if (this.size == this.list.length) {
            this.list = Arrays.copyOf(this.list, this.newSize());
        }
        this.list[this.size++] = e;
    }

    public E get(int p) {
        return (E)this.list[p];
    }

    public boolean contains(E e) {
        int i = 0;
        while (i < this.size) {
            if (this.list[i].equals(e)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void set(int i, E e) {
        if (i >= this.list.length) {
            this.list = Arrays.copyOf(this.list, this.newSize(i + 1));
        }
        this.list[i] = e;
        this.size = Math.max(this.size, i + 1);
    }

    public void delete(int i) {
        Array.move(this.list, i + 1, -1, --this.size - i);
    }

    public E[] toArray(E[] a) {
        if (a.length != this.size) {
            Util.notexpected(new Object[0]);
        }
        System.arraycopy(this.list, 0, a, 0, this.size);
        return a;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int c = -1;
            private boolean r;

            @Override
            public boolean hasNext() {
                if (!this.r) {
                    this.r = this.more();
                }
                return this.r;
            }

            @Override
            public E next() {
                if (!this.r) {
                    this.more();
                }
                this.r = false;
                return ObjList.this.list[this.c];
            }

            private boolean more() {
                return ++this.c < ObjList.this.size;
            }

            @Override
            public void remove() {
                Util.notexpected(new Object[0]);
            }
        };
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + Arrays.asList(this.list).subList(0, this.size);
    }
}

