unit dbmain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, FileCtrl, Buttons, StdCtrls, ASGSQLite, ComCtrls, ToolWin,
  ExtCtrls, DBCtrls, Grids, ValEdit, Menus, DB, DBGrids, ImgList;

type
  TFMain = class(TForm)
    ToolBar1: TToolBar;
    SB: TStatusBar;
    ADB: TASQLiteDB;
    Panel6: TPanel;
    PC: TPageControl;
    TabSheet1: TTabSheet;
    TSStructure: TTabSheet;
    Panel1: TPanel;
    DLB: TDirectoryListBox;
    Panel2: TPanel;
    SpeedButton1: TSpeedButton;
    FilterComboBox1: TFilterComboBox;
    Panel3: TPanel;
    DriveComboBox1: TDriveComboBox;
    Panel4: TPanel;
    Panel5: TPanel;
    FLB: TFileListBox;
    TV: TTreeView;
    ASQLiteLog1: TASQLiteLog;
    T: TASQLiteTable;
    ASQLitePragma1: TASQLitePragma;
    Splitter1: TSplitter;
    PageControl2: TPageControl;
    TabSheet4: TTabSheet;
    Panel7: TPanel;
    Splitter2: TSplitter;
    Panel8: TPanel;
    MSQL: TMemo;
    Panel9: TPanel;
    ToolBar2: TToolBar;
    DBNavigator1: TDBNavigator;
    UpdateSQL: TPageControl;
    TabSheet5: TTabSheet;
    TabSheet6: TTabSheet;
    DBGrid1: TDBGrid;
    ScrollBox1: TScrollBox;
    TabSheet7: TTabSheet;
    MLog: TMemo;
    ToolBar3: TToolBar;
    ToolButton1: TToolButton;
    MainMenu: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Create1: TMenuItem;
    Drop1: TMenuItem;
    Q: TASQLiteQuery;
    TSText: TTabSheet;
    MText: TMemo;
    ToolBar4: TToolBar;
    ToolBar5: TToolBar;
    ToolButton2: TToolButton;
    ImageList1: TImageList;
    DST: TDataSource;
    TSTable: TTabSheet;
    DSQ: TDataSource;
    Panel10: TPanel;
    ToolBar6: TToolBar;
    DBNavigator2: TDBNavigator;
    Label1: TLabel;
    ETableId: TEdit;
    DBGrid2: TDBGrid;
    TabSheet2: TTabSheet;
    TabSheet8: TTabSheet;
    TabSheet9: TTabSheet;
    TabSheet10: TTabSheet;
    Grid: TStringGrid;
    About1: TMenuItem;
    MInsert: TMemo;
    MUpdate: TMemo;
    MDelete: TMemo;
    U: TASQLiteUpdateSQL;
    Label2: TLabel;
    Edit1: TEdit;
    BitBtn1: TBitBtn;
    procedure FLBChange(Sender: TObject);
    procedure ToolButton2Click(Sender: TObject);
    procedure TVChange(Sender: TObject; Node: TTreeNode);
    procedure FLBDblClick(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure MInsertChange(Sender: TObject);
    procedure MUpdateChange(Sender: TObject);
    procedure MDeleteChange(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
    procedure TableCreateText(TheTable : string);
  public
    { Public declarations }
    FTableList : TStringList;
    FFieldList : TStringList;
  end;

var
  FMain: TFMain;

implementation

uses dbabout;

{$R *.dfm}

procedure TFMain.TableCreateText(TheTable : string);
begin
 MText.Lines.Add('');
 with Q do begin
  Close;
  SQL.Clear;
  SQL.Add('select * from sqlite_master where tbl_name=:t');
  Params[0].AsString := TheTable;
  Open;
  if not eof then
     MText.Lines.Add(FieldByName('sql').AsString);
  Close;
 end;
end;

procedure TFMain.FLBChange(Sender: TObject);
var
  TN1, TN2, TN3 : TTreeNode;
  i,j      : integer;
begin
 MText.Lines.Clear;
 ADB.Close;
 ADB.Database := ExtractFileName(FLB.FileName);
 ADB.DefaultDir := ExtractFileDir(FLB.FileName);
 if ADB.Database <> '' then begin
    ADB.Open;
    FTableList := TStringList.Create;
    FFieldList := TStringList.Create;
    ADB.GetTableNames(FTableList, true);
    TV.Items.Clear;
    TN1:= TV.Items.Add(nil, ADB.Database);
    TN1.ImageIndex := 1;
    TN1.SelectedIndex := 1;
    for i := 0 to FTableList.Count - 1 do begin
       TN2 := TV.Items.AddChild(TN1,FTableList[i]);
       TN2.ImageIndex := 2;
       TN2.SelectedIndex := 2;
       TableCreateText(FTableList[i]);
       ADB.GetFieldNames(FTableList[i],FFieldList);
       for j := 0 to FFieldList.Count - 1 do begin
         TN3 := TV.Items.AddChild(TN2,FFieldList[j]);
         TN3.ImageIndex := 3;
         TN3.SelectedIndex := 3;
       end;
    end;
    FTableList.Free;
    FFieldList.Free;
 end;

 SB.Panels[1].Text := FLB.FileName;
end;

procedure TFMain.ToolButton2Click(Sender: TObject);
begin
 with q do begin
  close;
  sql.Text := MSQL.Text;
  open;
 end;
end;

procedure TFMain.TVChange(Sender: TObject; Node: TTreeNode);
var List : TList;
    i     : integer;
begin
 if TV.Selected.ImageIndex <> 2 then exit;
 ETableId.Text := TV.Selected.Text;
 with t do begin
  close;
  TableName := ETableId.Text;
  MSQL.Lines.Clear;
  MSQL.Lines.Add('select * from '+TableName);
  MInsert.Text := 'insert into '+TableName+' * ';
  MUpdate.Text := 'update '+TableName+' set * where *';
  MDelete.Text := 'delete from '+TableName+' where *';
  open;

  List := TList.Create;
  ADB.GetTableInfo(ETableid.Text, List);
  Grid.Cells[0,0] := 'field';
  Grid.Cells[1,0] := 'type';
  Grid.Cells[2,0] := 'notnull';
  Grid.Cells[3,0] := 'default';
  Grid.Cells[4,0] := 'primary';
  for i := 1 to List.Count - 1 do begin
    Grid.RowCount := List.Count;
    with TASQLiteField(List[i]) do begin
      Grid.Cells[0,i] := FieldName;
      Grid.Cells[1,i] := FieldType;
      Grid.Cells[2,i] := BoolToStr((FieldNN = 1),true);
      Grid.Cells[3,i] := FieldDefault;
      Grid.Cells[4,i] := BoolToStr((FieldPK = 1),true);
    end;
  end;
 end;
end;

procedure TFMain.FLBDblClick(Sender: TObject);
begin
 PC.Activepage := TSStructure;
end;

procedure TFMain.About1Click(Sender: TObject);
begin
 FAbout := TFAbout.Create(Application);
 FAbout.ShowModal;
 FAbout.Free;
end;

procedure TFMain.MInsertChange(Sender: TObject);
begin
 U.InsertSQL.Text := MInsert.Text;
end;

procedure TFMain.MUpdateChange(Sender: TObject);
begin
 U.UpdateSQL.Text := MUpdate.Text;
end;

procedure TFMain.MDeleteChange(Sender: TObject);
begin
 U.DeleteSQL.Text := MDelete.Text;
end;

procedure TFMain.BitBtn1Click(Sender: TObject);
begin
 if T.Filtered then
    T.Filtered := false
 else begin
    T.Filter := Edit1.Text;
    T.Filtered := true;
 end;
end;

end.
