// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'ASGSQLite.pas' rev: 6.00

#ifndef ASGSQLiteHPP
#define ASGSQLiteHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <ASGRout.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <DB.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Asgsqlite
{
//-- type declarations -------------------------------------------------------
typedef int *pInteger;

typedef short *pSmallInt;

typedef Extended *pFloat;

typedef bool *pBoolean;

typedef char TConvertBuffer[255];

typedef int __cdecl (__closure *TSQLiteExecCallback)(System::TObject* Sender, int Columns, void * ColumnValues, void * ColumnNames);

typedef int __cdecl (__closure *TSQLiteBusyCallback)(System::TObject* Sender, char * ObjectName, int BusyCount);

typedef void __fastcall (__closure *TOnData)(System::TObject* Sender, int Columns, AnsiString ColumnNames, AnsiString ColumnValues);

typedef void __fastcall (__closure *TOnBusy)(System::TObject* Sender, AnsiString ObjectName, int BusyCount, bool &Cancel);

typedef void __fastcall (__closure *TOnQueryComplete)(System::TObject* Sender);

typedef void __fastcall (__closure *TASQLiteNotifyEvent)(System::TObject* Sender);

class DELPHICLASS TASQLiteField;
class PASCALIMPLEMENTATION TASQLiteField : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	int FieldNumber;
	AnsiString FieldName;
	AnsiString FieldType;
	int FieldNN;
	AnsiString FieldDefault;
	int FieldPK;
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TASQLiteField(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TASQLiteField(void) { }
	#pragma option pop
	
};


class DELPHICLASS TASQLitePragma;
class PASCALIMPLEMENTATION TASQLitePragma : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	int FTempCacheSize;
	int FDefaultCacheSize;
	AnsiString FDefaultSynchronous;
	AnsiString FDefaultTempStore;
	AnsiString FTempStore;
	AnsiString FSynchronous;
	
protected:
	AnsiString __fastcall GetTempCacheSize();
	AnsiString __fastcall GetDefaultCacheSize();
	AnsiString __fastcall GetDefaultSynchronous();
	AnsiString __fastcall GetDefaultTempStore();
	AnsiString __fastcall GetTempStore();
	AnsiString __fastcall GetSynchronous();
	
__published:
	__property int TempCacheSize = {read=FTempCacheSize, write=FTempCacheSize, nodefault};
	__property int DefaultCacheSize = {read=FDefaultCacheSize, write=FDefaultCacheSize, nodefault};
	__property AnsiString DefaultSynchronous = {read=FDefaultSynchronous, write=FDefaultSynchronous};
	__property AnsiString DefaultTempStore = {read=FDefaultTempStore, write=FDefaultTempStore};
	__property AnsiString TempStore = {read=FTempStore, write=FTempStore};
	__property AnsiString Synchronous = {read=FSynchronous, write=FSynchronous};
public:
	#pragma option push -w-inl
	/* TComponent.Create */ inline __fastcall virtual TASQLitePragma(Classes::TComponent* AOwner) : Classes::TComponent(AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TComponent.Destroy */ inline __fastcall virtual ~TASQLitePragma(void) { }
	#pragma option pop
	
};


class DELPHICLASS TASQLiteLog;
class PASCALIMPLEMENTATION TASQLiteLog : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	AnsiString FLogFile;
	bool FLogDebugOut;
	bool FAppend;
	bool FLogSQL;
	bool FLogInt;
	
public:
	void __fastcall Display(AnsiString Msg);
	
__published:
	__property AnsiString LogFile = {read=FLogFile, write=FLogFile};
	__property bool LogDebugOut = {read=FLogDebugOut, write=FLogDebugOut, nodefault};
	__property bool Append = {read=FAppend, write=FAppend, nodefault};
	__property bool LogSQL = {read=FLogSQL, write=FLogSQL, nodefault};
	__property bool LogInternals = {read=FLogInt, write=FLogInt, nodefault};
public:
	#pragma option push -w-inl
	/* TComponent.Create */ inline __fastcall virtual TASQLiteLog(Classes::TComponent* AOwner) : Classes::TComponent(AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TComponent.Destroy */ inline __fastcall virtual ~TASQLiteLog(void) { }
	#pragma option pop
	
};


class DELPHICLASS TASQLiteDB;
class PASCALIMPLEMENTATION TASQLiteDB : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	TASQLiteNotifyEvent FAfterConnect;
	TASQLiteNotifyEvent FBeforeConnect;
	TASQLiteNotifyEvent FAfterDisconnect;
	TASQLiteNotifyEvent FBeforeDisconnect;
	
protected:
	AnsiString FDatabase;
	AnsiString FDefaultExt;
	AnsiString FDefaultDir;
	AnsiString FDriverDll;
	bool FConnected;
	bool FMustExist;
	AnsiString FVersion;
	AnsiString FCharEncoding;
	void *DBHandle;
	TASQLitePragma* FASQLitePragma;
	TASQLiteLog* FASQLiteLog;
	AnsiString FLastError;
	void * __cdecl (*SQLite_Open)(char * dbname, int mode, char * &ErrMsg);
	void __cdecl (*SQLite_Close)(void * db);
	int __cdecl (*SQLite_Exec)(void * db, char * SQLStatement, void * CallbackPtr, System::TObject* Sender, char * &ErrMsg);
	char * __cdecl (*SQLite_Version)(void);
	char * __cdecl (*SQLite_Encoding)(void);
	char * __cdecl (*SQLite_ErrorString)(int ErrNo);
	int __cdecl (*SQLite_GetTable)(void * db, char * SQLStatement, void * &ResultPtr, unsigned &RowCount, unsigned &ColCount, char * &ErrMsg);
	void __cdecl (*SQLite_FreeTable)(char * Table);
	void __cdecl (*SQLite_FreeMem)(char * P);
	bool __cdecl (*SQLite_Complete)(char * P);
	int __cdecl (*SQLite_LastInsertRow)(void * db);
	void __cdecl (*SQLite_Cancel)(void * db);
	void __cdecl (*SQLite_BusyHandler)(void * db, void * CallbackPtr, System::TObject* Sender);
	void __cdecl (*SQLite_BusyTimeout)(void * db, int TimeOut);
	int __cdecl (*SQLite_Changes)(void * db);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation);
	void __fastcall DBConnect(bool Connected);
	AnsiString __fastcall FGetDefaultExt();
	
public:
	unsigned DLLHandle;
	__fastcall virtual TASQLiteDB(Classes::TComponent* AOwner);
	__fastcall virtual ~TASQLiteDB(void);
	bool __fastcall LoadLibs(void);
	void __fastcall FSetDatabase(AnsiString Database);
	AnsiString __fastcall FGetDriverDLL();
	int __fastcall RowsAffected(void);
	void __fastcall StartTransaction(void);
	void __fastcall Open(void);
	void __fastcall Close(void);
	void __fastcall Commit(void);
	void __fastcall RollBack(void);
	void __fastcall ShowDatabases(Classes::TStrings* List);
	void __fastcall GetTableNames(Classes::TStrings* List, bool SystemTables = false);
	void __fastcall GetTableInfo(AnsiString TableName, Classes::TList* List);
	void __fastcall GetIndexNames(Classes::TStrings* List, bool SystemTables = false);
	void __fastcall GetFieldNames(AnsiString TableName, Classes::TStrings* List);
	void __fastcall GetPrimaryKeys(AnsiString TableName, Classes::TStrings* List);
	void __fastcall GetTableIndexNames(AnsiString TableName, Classes::TStrings* List);
	void __fastcall ExecPragma(void);
	int __cdecl SQLite_XExec(void * db, char * SQLStatement, void * CallbackPtr, System::TObject* Sender, char * &ErrMsg);
	
__published:
	__property AnsiString Database = {read=FDatabase, write=FSetDatabase};
	__property TASQLitePragma* ASQLitePragma = {read=FASQLitePragma, write=FASQLitePragma};
	__property TASQLiteLog* ASQLiteLog = {read=FASQLiteLog, write=FASQLiteLog};
	__property AnsiString DefaultExt = {read=FGetDefaultExt, write=FDefaultExt};
	__property AnsiString DefaultDir = {read=FDefaultDir, write=FDefaultDir};
	__property AnsiString Version = {read=FVersion, write=FVersion};
	__property AnsiString CharacterEncoding = {read=FCharEncoding, write=FCharEncoding};
	__property AnsiString DriverDLL = {read=FGetDriverDLL, write=FDriverDll};
	__property bool Connected = {read=FConnected, write=DBConnect, nodefault};
	__property bool MustExist = {read=FMustExist, write=FMustExist, nodefault};
	__property TASQLiteNotifyEvent AfterConnect = {read=FAfterConnect, write=FAfterConnect};
	__property TASQLiteNotifyEvent BeforeConnect = {read=FBeforeConnect, write=FBeforeConnect};
	__property TASQLiteNotifyEvent AfterDisconnect = {read=FAfterDisconnect, write=FAfterDisconnect};
	__property TASQLiteNotifyEvent BeforeDisconnect = {read=FBeforeDisconnect, write=FBeforeDisconnect};
};


class DELPHICLASS AsgError;
class PASCALIMPLEMENTATION AsgError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall AsgError(const AnsiString Msg) : Sysutils::Exception(Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall AsgError(const AnsiString Msg, const System::TVarRec * Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall AsgError(int Ident)/* overload */ : Sysutils::Exception(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall AsgError(int Ident, const System::TVarRec * Args, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall AsgError(const AnsiString Msg, int AHelpContext) : Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall AsgError(const AnsiString Msg, const System::TVarRec * Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall AsgError(int Ident, int AHelpContext)/* overload */ : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall AsgError(System::PResStringRec ResStringRec, const System::TVarRec * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~AsgError(void) { }
	#pragma option pop
	
};


struct TRecInfo;
typedef TRecInfo *PRecInfo;

#pragma pack(push, 1)
struct TRecInfo
{
	int Bookmark;
	Db::TBookmarkFlag BookmarkFlag;
} ;
#pragma pack(pop)

class DELPHICLASS TFResult;
class PASCALIMPLEMENTATION TFResult : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	Classes::TList* Data;
	Classes::TList* BookMark;
	Classes::TList* RowId;
	int FLastBookmark;
	int FBufSize;
	
public:
	__fastcall TFResult(void);
	__fastcall virtual ~TFResult(void);
	void __fastcall SetBufSize(int TheSize);
	void __fastcall Add(char * TheBuffer, int TheRowId);
	void __fastcall Insert(int Index, void * TheBuffer, int TheRowId);
	void __fastcall Delete(int Index);
	void * __fastcall GetData(int Index);
	int __fastcall Count(void);
	int __fastcall IndexOf(void * TheBookMark);
	int __fastcall GetBookmark(int Index);
	int __fastcall GetRowId(int Index);
};


class DELPHICLASS TASQLiteUpdateSQL;
class PASCALIMPLEMENTATION TASQLiteUpdateSQL : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	Classes::TStrings* FInsertSQL;
	Classes::TStrings* FUpdateSQL;
	Classes::TStrings* FDeleteSQL;
	void __fastcall SetInsertSQL(const Classes::TStrings* Value);
	void __fastcall SetUpdateSQL(const Classes::TStrings* Value);
	void __fastcall SetDeleteSQL(const Classes::TStrings* Value);
	
public:
	__fastcall virtual TASQLiteUpdateSQL(Classes::TComponent* AOwner);
	__fastcall virtual ~TASQLiteUpdateSQL(void);
	
__published:
	__property Classes::TStrings* InsertSQL = {read=FInsertSQL, write=SetInsertSQL};
	__property Classes::TStrings* UpdateSQL = {read=FUpdateSQL, write=SetUpdateSQL};
	__property Classes::TStrings* DeleteSQL = {read=FDeleteSQL, write=SetDeleteSQL};
};


class DELPHICLASS TASQLiteBaseQuery;
class PASCALIMPLEMENTATION TASQLiteBaseQuery : public Db::TDataSet 
{
	typedef Db::TDataSet inherited;
	
private:
	bool FTypeLess;
	bool FNoResults;
	bool FAutoCommit;
	TFResult* FResult;
	Classes::TList* BLOB;
	Classes::TStrings* FSQL;
	AnsiString FPrepared;
	int FRecBufSize;
	int FRecInfoOfs;
	int FCurRec;
	AnsiString FMasterFields;
	Db::TDataSource* FMasterSource;
	AnsiString FLastError;
	bool FSaveChanges;
	bool FMetaData;
	int MaxStrLen;
	TASQLiteDB* FConnection;
	int FMaxResults;
	int FStartResult;
	int CurrentRowId;
	AnsiString SQLStr;
	char *ResultStr;
	Classes::TList* DetailList;
	void __fastcall SetSQL(const Classes::TStrings* Value);
	char __fastcall UnpackBuffer(char * Buffer, Db::TFieldType FieldType);
	void __fastcall SetDataSource(Db::TDataSource* Value);
	
protected:
	void __fastcall RegisterDetailDataset(TASQLiteBaseQuery* DetailDataSet);
	void __fastcall LoadQueryData(void);
	bool __fastcall GetActiveBuffer(char * &Buffer);
	virtual Db::TDataSource* __fastcall GetDataSource(void);
	void __fastcall NotifySQLiteMasterChanged(void);
	virtual char * __fastcall AllocRecordBuffer(void);
	virtual void __fastcall FreeRecordBuffer(char * &Buffer);
	virtual void __fastcall GetBookmarkData(char * Buffer, void * Data);
	virtual Db::TBookmarkFlag __fastcall GetBookmarkFlag(char * Buffer);
	virtual Db::TGetResult __fastcall GetRecord(char * Buffer, Db::TGetMode GetMode, bool DoCheck);
	virtual Word __fastcall GetRecordSize(void);
	virtual void __fastcall InternalAddRecord(void * Buffer, bool Append);
	virtual void __fastcall InternalClose(void);
	virtual void __fastcall InternalDelete(void);
	virtual void __fastcall InternalFirst(void);
	virtual void __fastcall InternalGotoBookmark(void * Bookmark);
	virtual void __fastcall InternalHandleException(void);
	virtual void __fastcall InternalInitFieldDefs(void);
	virtual void __fastcall InternalInitRecord(char * Buffer);
	virtual void __fastcall InternalLast(void);
	virtual void __fastcall InternalOpen(void);
	virtual void __fastcall InternalPost(void);
	virtual void __fastcall InternalSetToRecord(char * Buffer);
	virtual bool __fastcall IsCursorOpen(void);
	virtual void __fastcall SetBookmarkFlag(char * Buffer, Db::TBookmarkFlag Value);
	virtual void __fastcall SetBookmarkData(char * Buffer, void * Data);
	virtual void __fastcall SetFieldData(Db::TField* Field, void * Buffer)/* overload */;
	int __fastcall GetFieldSize(int FieldNo);
	int __fastcall GetNativeFieldSize(int FieldNo);
	int __fastcall GetFieldOffset(int FieldNo);
	AnsiString __fastcall GetMasterFields();
	void __fastcall SetMasterFields(const AnsiString Value);
	virtual int __fastcall GetRecordCount(void);
	virtual int __fastcall GetRecNo(void);
	virtual void __fastcall SetRecNo(int Value);
	__property Classes::TStrings* BaseSQL = {read=FSQL, write=SetSQL};
	virtual void __fastcall SetFilterText(const AnsiString Value);
	int __fastcall GetNewBLOBHandle(void);
	void __fastcall SetBLOBData(int BlobHandle, void * BlobData);
	void * __fastcall GetBLOBData(int BlobHandle);
	
public:
	__fastcall virtual TASQLiteBaseQuery(Classes::TComponent* AOwner);
	__fastcall virtual ~TASQLiteBaseQuery(void);
	void __fastcall StartTransaction(void);
	void __fastcall Commit(void);
	void __fastcall RollBack(void);
	virtual void __fastcall SetFiltered(bool Value);
	virtual void __fastcall SQLiteMasterChanged(void);
	virtual bool __fastcall GetFieldData(Db::TField* Field, void * Buffer)/* overload */;
	virtual bool __fastcall GetFieldData(int FieldNo, void * Buffer)/* overload */;
	virtual bool __fastcall GetFieldData(Db::TField* Field, void * Buffer, bool NativeFormat)/* overload */;
	virtual Classes::TStream* __fastcall CreateBlobStream(Db::TField* Field, Db::TBlobStreamMode Mode);
	virtual bool __fastcall Locate(const AnsiString KeyFields, const Variant &KeyValues, Db::TLocateOptions Options);
	virtual bool __fastcall BookmarkValid(void * Bookmark);
	
__published:
	__property bool AutoCommit = {read=FAutoCommit, write=FAutoCommit, default=1};
	__property TASQLiteDB* Connection = {read=FConnection, write=FConnection};
	__property int MaxResults = {read=FMaxResults, write=FMaxResults, nodefault};
	__property int StartResult = {read=FStartResult, write=FStartResult, nodefault};
	__property bool TypeLess = {read=FTypeLess, write=FTypeLess, default=0};
	__property AnsiString MasterFields = {read=GetMasterFields, write=SetMasterFields};
	__property Db::TDataSource* MasterSource = {read=GetDataSource, write=SetDataSource};
	__property Filter ;
	__property Filtered  = {default=0};
	__property Active  = {default=0};
	__property BeforeOpen ;
	__property AfterOpen ;
	__property BeforeClose ;
	__property AfterClose ;
	__property BeforeInsert ;
	__property AfterInsert ;
	__property BeforeEdit ;
	__property AfterEdit ;
	__property BeforePost ;
	__property AfterPost ;
	__property BeforeCancel ;
	__property AfterCancel ;
	__property BeforeDelete ;
	__property AfterDelete ;
	__property BeforeScroll ;
	__property AfterScroll ;
	__property BeforeRefresh ;
	__property AfterRefresh ;
	__property OnCalcFields ;
	__property OnDeleteError ;
	__property OnEditError ;
	__property OnNewRecord ;
	__property OnPostError ;
	
/* Hoisted overloads: */
	
protected:
	inline void __fastcall  SetFieldData(Db::TField* Field, void * Buffer, bool NativeFormat){ TDataSet::SetFieldData(Field, Buffer, NativeFormat); }
	
};


class DELPHICLASS TASQLiteQuery;
class PASCALIMPLEMENTATION TASQLiteQuery : public TASQLiteBaseQuery 
{
	typedef TASQLiteBaseQuery inherited;
	
private:
	Db::TParams* FParams;
	TASQLiteUpdateSQL* FUpdateSQL;
	bool FRawSQL;
	HIDESBASE void __fastcall SetSQL(const Classes::TStrings* Value);
	Classes::TStrings* __fastcall GetSQL(void);
	void __fastcall SetParamsList(Db::TParams* Value);
	void __fastcall QueryChanged(System::TObject* Sender);
	
protected:
	virtual void __fastcall InternalOpen(void);
	virtual void __fastcall InternalPost(void);
	virtual void __fastcall InternalDelete(void);
	Word __fastcall GetParamsCount(void);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation);
	virtual void __fastcall InternalClose(void);
	
public:
	__fastcall virtual TASQLiteQuery(Classes::TComponent* AOwner);
	__fastcall virtual ~TASQLiteQuery(void);
	void __fastcall ExecSQL(void);
	__property Db::TParams* Params = {read=FParams, write=SetParamsList, stored=false};
	virtual void __fastcall SQLiteMasterChanged(void);
	
__published:
	__property bool RawSQL = {read=FRawSQL, write=FRawSQL, default=0};
	__property Classes::TStrings* SQL = {read=GetSQL, write=SetSQL};
	__property TASQLiteUpdateSQL* UpdateSQL = {read=FUpdateSQL, write=FUpdateSQL};
};


class DELPHICLASS TASQLiteTable;
class PASCALIMPLEMENTATION TASQLiteTable : public TASQLiteBaseQuery 
{
	typedef TASQLiteBaseQuery inherited;
	
private:
	AnsiString FTableName;
	bool FPrimaryAutoInc;
	
protected:
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation);
	virtual void __fastcall InternalOpen(void);
	virtual void __fastcall InternalPost(void);
	virtual void __fastcall InternalDelete(void);
	
public:
	virtual void __fastcall SQLiteMasterChanged(void);
	
__published:
	__property AnsiString TableName = {read=FTableName, write=FTableName};
	__property bool PrimaryAutoInc = {read=FPrimaryAutoInc, write=FPrimaryAutoInc, nodefault};
public:
	#pragma option push -w-inl
	/* TASQLiteBaseQuery.Create */ inline __fastcall virtual TASQLiteTable(Classes::TComponent* AOwner) : TASQLiteBaseQuery(AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TASQLiteBaseQuery.Destroy */ inline __fastcall virtual ~TASQLiteTable(void) { }
	#pragma option pop
	
};


class DELPHICLASS TASQLiteBlobStream;
class PASCALIMPLEMENTATION TASQLiteBlobStream : public Classes::TMemoryStream 
{
	typedef Classes::TMemoryStream inherited;
	
private:
	Db::TBlobField* FField;
	TASQLiteBaseQuery* FDataSet;
	Db::TBlobStreamMode FMode;
	bool FModified;
	bool FOpened;
	void __fastcall LoadBlobData(void);
	void __fastcall SaveBlobData(void);
	
public:
	__fastcall TASQLiteBlobStream(Db::TBlobField* Field, Db::TBlobStreamMode Mode);
	__fastcall virtual ~TASQLiteBlobStream(void);
	virtual int __fastcall Read(void *Buffer, int Count);
	virtual int __fastcall Write(const void *Buffer, int Count);
};


//-- var, const, procedure ---------------------------------------------------
#define SQLiteVersion "ASGSQLite V1.2.C beta"
static const Word MaxBuf = 0x7530;
static const Shortint SQLite_OK = 0x0;
static const Shortint SQLite_ERROR = 0x1;
static const Shortint SQLite_INTERNAL = 0x2;
static const Shortint SQLite_PERM = 0x3;
static const Shortint SQLite_ABORT = 0x4;
static const Shortint SQLite_BUSY = 0x5;
static const Shortint SQLite_LOCKED = 0x6;
static const Shortint SQLite_NOMEM = 0x7;
static const Shortint SQLite_READONLY = 0x8;
static const Shortint SQLite_INTERRUPT = 0x9;
static const Shortint SQLite_IOERR = 0xa;
static const Shortint SQLite_CORRUPT = 0xb;
static const Shortint SQLite_NOTFOUND = 0xc;
static const Shortint SQLite_FULL = 0xd;
static const Shortint SQLite_CANTOPEN = 0xe;
static const Shortint SQLite_PROTOCOL = 0xf;
static const Shortint SQLite_EMPTY = 0x10;
static const Shortint SQLite_SCHEMA = 0x11;
static const Shortint SQLite_TOOBIG = 0x12;
static const Shortint SQLite_CONSTRAINT = 0x13;
static const Shortint SQLite_MISMATCH = 0x14;
extern PACKAGE AnsiString Crlf;
static const char Q = '\x27';

}	/* namespace Asgsqlite */
using namespace Asgsqlite;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// ASGSQLite
