unit Unit2;

interface

uses
  SysUtils, Classes, HTTPApp, StrUtils, HTTPProd, DSProd, OleServer,
  ASGSQLite3, DB;

type
  TWebModule2 = class(TWebModule)
    DataSetPageProducer1: TDataSetPageProducer;
    PageProducer2: TPageProducer;
    DataSetPageProducer2: TDataSetPageProducer;
    PageProducer1: TPageProducer;
    ASQLite3DB1: TASQLite3DB;
    ASQLite3Table1: TASQLite3Table;
    ASQLite3Log1: TASQLite3Log;
    DataSource1: TDataSource;
    ASQLite3Query1: TASQLite3Query;
    ASQLite3UpdateSQL1: TASQLite3UpdateSQL;
    PageProducer3: TPageProducer;
    procedure WebModuleCreate(Sender: TObject);
    procedure WebModuleDestroy(Sender: TObject);
    procedure WebModuleBeforeDispatch(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModule2indexAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModuleAfterDispatch(Sender: TObject; Request: TWebRequest;
      Response: TWebResponse; var Handled: Boolean);
    procedure PageProducer2HTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
    procedure WebModule2RegistAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure DataSetPageProducer1HTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
    procedure WebModule2UsrdelAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure PageProducer1HTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
    procedure PageProducer3HTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
    procedure WebModule2admin2Action(Sender: TObject; Request: TWebRequest;
      Response: TWebResponse; var Handled: Boolean);
    procedure WebModule2admdelAction(Sender: TObject; Request: TWebRequest;
      Response: TWebResponse; var Handled: Boolean);
    procedure WebModule2errorAction(Sender: TObject; Request: TWebRequest;
      Response: TWebResponse; var Handled: Boolean);
  private
    { Private declarations }
    title1, title2: string;
    head, body, foot, page: string;
    pos: integer;
    admin_pass: string;
    r_name: string;
    home: string;
    page_def: integer;
    maxn, maxs, maxv: integer;
    maxline: integer;
    w_regist: Int64;
    autolink, tag: Boolean;
    mudai: string;
    re_color: string;
    hostview: integer;
    no_host, no_word: TStringList;
    l_count: integer;
    loginlist: TStringList;
    function LinkContent(path: string): string;
    function footer(path: string): string;
  public
    { Public declarations }
  end;

const
    GAIBU: Boolean = true;
    LOCKEY: integer = 1;
    LOCK: string = 'lock/plock';

var
  WebModule2: TWebModule2;

implementation

uses WebReq, DateUtils;

{$R *.DFM}

procedure TWebModule2.WebModuleCreate(Sender: TObject);
begin//ŏƃfobO[hƐݒuiKƂŋقȂ̂ōD܂Ȃ
//* <title>ɓ^Cg */
        title1 := 'P-BBS';
//* fTOP^CgiHTMLj*/
        title2 := '<font size=5 face=Verdana color=gray><b>P-BBS</b></font>';
//* <body>^O */
        body := '<body bgcolor="#ddf2ed" text="#444444" link="#0000AA">';
//* ǗҗppX[hBKύXĉB*/
        admin_pass := 'full';
//* y[W̕\L */
        page_def := 10;

        l_count:=5;
        pos:=-1;
//* iOA薼A{jSpƂ̔ł */
        maxn  := 40;
        maxs  := 40;
        maxv  := 1500;
//* {̉s */
        maxline := 25;
//* zXg̘Ae𐧌
//  --> bLqƂ̎Ԉȏo߂ȂƘAełȂ*/
        w_regist := 5;
//* ŎN邩ǂiyes=1 no=0j*/
        autolink := true;
//* HTML^OLɂ邩iyes=1 no=0)*/
        tag := true;
//* ^Cgœeꂽꍇ */
        mudai := '()';
//* ̐F */
        re_color := '#225588';
//* zXg\邩i\Ȃ=0 <!-->ŕ\=1 \=2j*/
        hostview := 1;
//* O݋֎~ɂ?(=1,Ȃ=0) */
//define("GAIBU", 0);

//* gpt@CbÑ^Cvimkdir=1 flock=2 gȂ=0j*/
//define("LOCKEY", 2); 		//ʏ2OK
//* mkdirbNglockƂŃfBNg쐬777ɂĂ */
//define("LOCK" , "lock/plock");	//lock̒ɍ郍bNt@C
        no_host:=TStringList.Create;
        no_host.CommaText:='"kantei.go.jp","anonymizer.com","pt$","ph$","my$","th$","rr.com"';
        no_word:=TStringList.Create;
        no_word.CommaText:='"","n","novapublic"';
        loginlist:=TStringList.Create;
        loginlist.CommaText:='"/admin2","/admdel","/next","/back"';
end;

procedure TWebModule2.WebModuleDestroy(Sender: TObject);
begin
        no_host.Free;
        no_word.Free;
        loginlist.Free;
end;

procedure TWebModule2.WebModuleBeforeDispatch(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  i: integer;
begin
        ASQLite3Query1.ExecSQL;
        ASQLite3Table1.TableName:='pbbs';
        ASQLite3Table1.Active:=true;;
        home:='http://'+Request.Host+Request.InternalScriptName+'/';
        head:='<html><head><META HTTP-EQUIV="Content-type" CONTENT="text/html; charset=Shift_JIS"><title>'+
                title1+'</title></head>';
        foot:='[ <a href='+home+'>z[</a> ] [ <a href='+home+'admin>Ǘ</a> ]'+
                '<br><br><small><!-- P-BBS v1.232 -->- <a href="http://php.s3.to" target="_top">P-BBS</a> -</small>'+
                '</body></html>';
  if loginlist.IndexOf(Request.InternalPathInfo) = -1 then
  begin
    with Response.Cookies.Add do
    begin
        Name:='admin_pass';
        Value:='';
//        Secure:=true;
    end;
  end;
  for i:=0 to no_host.Count-1 do
  begin
    if AnsiContainsText(Request.URL,no_host[i]) = true then
    begin
        Response.StatusCode:=204;
        Handled:=true;
        break;
    end;
  end;
end;

procedure TWebModule2.WebModule2indexAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
        r_name:=Request.CookieFields.Values['name'];
        pos:=StrToIntDef(Request.Query,-1);
        Response.Content:=PageProducer2.Content;
end;

procedure TWebModule2.WebModuleAfterDispatch(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
        ASQLite3Table1.Active:=false;
end;

procedure TWebModule2.PageProducer2HTMLTag(Sender: TObject; Tag: TTag;
  const TagString: String; TagParams: TStrings; var ReplaceText: String);
var
  s: string;
  count: integer;
begin
  if TagString = 'page_def' then
  begin
        ReplaceText:=IntToStr(page_def);
  end;
  if TagString = 'home' then
  begin
        ReplaceText:=home;
  end;
  if TagString = 'main' then
  begin
        s:='';
    if (pos = -1)or((pos+1)*page_def > ASQLite3Table1.RecordCount) then
    begin
        ASQLite3Table1.Last;
      if pos <> -1 then
      begin
                pos:=ASQLite3Table1.RecordCount div page_def;
      end;
    end else
    begin
        ASQLite3Table1.RecNo:=(pos+1)*page_def-1;
    end;
        count:=0;
    while (ASQLite3Table1.Bof = false)and((pos = -1)or(ASQLite3Table1.RecNo >= pos*page_def)) do
    begin
      if count > page_def then
      begin
                break;
      end;
        s:=s+DataSetPageProducer2.Content;
        ASQLite3Table1.Prior;
        inc(count);
    end;
        ReplaceText:=s;
  end;
  if TagString = 'title2' then
  begin
        ReplaceText:=title2;
  end;
  if TagString = 'r_name' then
  begin
        ReplaceText:=r_name;
  end;
  if TagString = 'foot' then
  begin
        ReplaceText:=footer('');
  end;
end;

procedure TWebModule2.WebModule2RegistAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  i: integer;
  s, name, pass, sub, com: string;
  x: TDateTime;
  y: Int64;
  procedure linecount;
  var
    j: integer;
    temp: TStringList;
  begin
        temp:=TStringList.Create;
    try
        temp.Text:=com;
      if temp.Count > maxline then
      begin
                s:=s+'s܂<br>';
      end else
      begin
                com:='';
        for j:=0 to temp.Count-1 do
        begin
                com:=com+'<br>'+temp[j];
        end;
      end;
    finally
        temp.Free;
    end;
  end;
  procedure cookie;
  begin
    with Response.Cookies.Add do
    begin
        Name:='name';
        Value:=Request.Authorization;
    if Value = '' then
    begin
        Value:=Request.ContentFields.Values['name'];
    end;
        Expires:=Now+20;
    end;
  end;
begin
        s:='';
  if Request.Method <> 'POST' then
  begin
        s:=s+'sȓeȂł<br>';
  end;
  if (GAIBU = false)and(AnsiContainsStr(Request.URL,home) = false) then
  begin
        s:=s+'O珑݂ł܂<br>';
  end;
        name:=Request.ContentFields.Values['name'];
        sub:=Request.ContentFields.Values['sub'];
        com:=Request.ContentFields.Values['com'];
        pass:=Request.ContentFields.Values['password'];
  if name = '' then
  begin
        name:='no name';
  end else
        if Length(name) > maxn then
  begin
        s:=s+'O܂<br>';
  end;
  if sub = '' then
  begin
        sub:=mudai;
  end else
        if Length(sub) > maxs then
  begin
        s:=s+'^Cg܂<br>';
  end;
  if com = '' then
  begin
        s:=s+'{܂Ă܂<br>';
  end else
        if Length(com) > maxv then
  begin
        s:=s+'{܂<br>';
  end;
  for i:=0 to no_word.Count-1 do
  begin
    if (AnsiContainsText(com,no_word[i]) = true)or(AnsiContainsText(sub,no_word[i]) = true)or
      (AnsiContainsText(name,no_word[i]) = true) then
    begin
        s:=s+'gpłȂt܂܂Ă܂<br>';
    end;
  end;
        ASQLite3Table1.Last;
        x:=Now;
        y:=SecondsBetween(x,ASQLite3Table1.FieldByName('date').AsFloat);
  if (ASQLite3Table1.FieldByName('com').AsString = com)and
    (ASQLite3Table1.FieldByName('name').AsString = name) then
  begin
        Response.SendRedirect(home);
        Exit;
  end;
  if y < w_regist then
  begin
        s:=s+'ݍĂ܂@c'+IntToStr(w_regist-y)+'b<br>';
  end;
        linecount;
        cookie;
  if s <> '' then
  begin
        Response.Content:=head+s+'uEU̖߂ňړĂB</body></html>';
  end else
  begin
        ASQLite3Table1.Last;
    if ASQLite3Table1.RecordCount = 0 then
    begin
        i:=0
    end else
    begin
        i:=ASQLite3Table1.FieldByName('no').AsInteger+1;
    end;
        ASQLite3Table1.AppendRecord([pass,i,Now,name,sub,com]);
        Response.SendRedirect(home+'?-1');
  end;
end;

procedure TWebModule2.DataSetPageProducer1HTMLTag(Sender: TObject;
  Tag: TTag; const TagString: String; TagParams: TStrings;
  var ReplaceText: String);
begin
  if TagString = 'home' then
  begin
        ReplaceText:=home;
  end else
        if TagString = 'now' then
  begin
        ReplaceText:=DateTimeToStr(ASQLite3Table1.FieldByName('date').AsFloat);
  end else
  begin
        ReplaceText:=ASQLite3Table1.FieldByName(TagString).AsString;
  end;
end;

procedure TWebModule2.WebModule2UsrdelAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  s, t: string;
  x: Boolean;
  no, pwd: string;
begin
        no:=Request.ContentFields.Values['no'];
        pwd:=Request.ContentFields.Values['pwd'];
  if (no = '')or(pwd = '') then
  begin
        t:='폜no܂͍폜L[͂ł';
  end;
        s:='';
        x:=false;
  with ASQLite3Table1 do
  begin
        First;
  while Eof = false do
  begin
    if FieldByName('no').AsString = no then
    begin
        s:=ASQLite3Table1.FieldByName('pass').AsString;
        x:=true;
        break
    end;
        Next;
  end;
  end;
  if x = true then
  begin
    if s = '' then
    begin
        t:='YLɂ͍폜L[ݒ肳Ă܂)';
    end else
        if s <> pwd then
    begin
        t:='폜L[Ⴂ܂';
    end;
  end else
  begin
        t:='YL܂';
  end;
  if t <> '' then
  begin
        Response.Content:=head+t+'</body></html>';
  end else
  begin
        s:=Request.ContentFields.Values['no'];
    with ASQLite3Table1 do
    begin
        First;
    while Eof = false do
    begin
      if s = FieldByName('no').AsString then
      begin
                Delete;
                break;
      end;
        Next;
    end;
    end;
        Response.SendRedirect(home);
  end;
end;

procedure TWebModule2.PageProducer1HTMLTag(Sender: TObject; Tag: TTag;
  const TagString: String; TagParams: TStrings; var ReplaceText: String);
var
  count: integer;
begin
  if TagString = 'home' then
  begin
        ReplaceText:=home;
  end;
  if TagString = 'main' then
  begin
    with ASQLite3Table1 do
    begin
    if (pos = -1)or((pos+1)*page_def > RecordCount) then
    begin
        Last;
      if pos <> -1 then
      begin
                pos:=ASQLite3Table1.RecordCount div page_def;
      end;
    end else
    begin
        RecNo:=(pos+1)*page_def-1;
    end;
        count:=0;
    while (Bof = false)and((pos = -1)or(RecNo >= pos*page_def)) do
    begin
      if count > page_def then
      begin
                break;
      end;
        ReplaceText:=ReplaceText+DataSetPageProducer1.Content;
        Prior;
        inc(count);
    end;
    end;
  end;
  if TagString = 'pos' then
  begin
        ReplaceText:=IntToStr(pos);
  end;
end;

procedure TWebModule2.PageProducer3HTMLTag(Sender: TObject; Tag: TTag;
  const TagString: String; TagParams: TStrings; var ReplaceText: String);
begin
  if TagString = 'home' then
  begin
        ReplaceText:=home;
  end;
end;

procedure TWebModule2.WebModule2admin2Action(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  pwd: string;
begin
  if (Request.ContentFields.IndexOfName('apass') = -1)or(Request.MethodType <> mtPost) then
  begin
        pwd:=Request.CookieFields.Values['admin_pass'];
  end else
  begin
        pwd:=Request.ContentFields.Values['apass'];
  end;
  if admin_pass = pwd then
  begin
        pos:=StrToIntDef(Request.Query,-1);
        Response.Content:=PageProducer1.Content+footer('admin2');
    with Response.Cookies.Add do
    begin
        Name:='admin_pass';
        Value:=pwd;
//        Secure:=true;
    end;
  end else
  begin
    if Request.MethodType <> mtPost then
    begin
        Response.Content:='OCĂ';
    end else
    begin
        Response.Content:='pX[h܂';
    end;
  end;
end;

procedure TWebModule2.WebModule2admdelAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  i: integer;
  s: string;
begin
  for i:=0 to Request.ContentFields.Count-1 do
  begin
        s:=Request.ContentFields.Values[Request.ContentFields.Names[i]];
    with ASQLite3Table1 do
    begin
        First;
    while Eof = false do
    begin
      if s = FieldByName('no').AsString then
      begin
                Delete;
      end else
      begin
                Next;
      end;
    end;
    end;
  end;
        Response.SendRedirect(home+'admin2?'+Request.Query);
end;

function TWebModule2.LinkContent(path: string): string;
var
  i, j: integer;
begin
        result:='';
  if pos > l_count div 2 then
  begin
        j:=-(l_count div 2);
  end else
  begin
        j:=-pos;
  end;
  for i:=0 to l_count-1 do
  begin
    if ASQLite3Table1.RecordCount < (pos+i+j)*page_def then
    begin
        break;
    end;
    if i+j = 0 then
    begin
        result:=result+'@'+IntToStr(pos)+'@';
    end else
    begin
        result:=result+Format('@<a href="'+home+path+'?%d">%d</a>@',[pos+i+j,pos+i+j]);
    end;
  end;
end;

procedure TWebModule2.WebModule2errorAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
        Response.SendRedirect(home);
end;

function TWebModule2.footer(path: string): string;
var
  s, t, u: string;
  i: integer;
begin
  if pos = -1 then
  begin
        s:='<hr size=1>ŐV%d̋L\<br><center>Pages:[<b>';
        page:='<<'+LinkContent(path)+'>>]@ŐV<br></center>';
        result:=Format(s,[page_def])+page+foot;
  end else
  begin
    if pos = 0 then
    begin
        t:='?0';
        u:='?'+IntToStr(pos+1);
    end else
    begin
        i:=ASQLite3Table1.RecordCount div page_def;
        t:='?'+IntToStr(pos-1);
      if pos = i then
      begin
                u:='?'+IntToStr(i);
      end else
      begin
                u:='?'+IntToStr(pos+1);
      end;
    end;
        page:='<a href="'+home+path+t+'"><<</a>'+LinkContent(path)+
                '<a href="'+home+path+u+'">>></a>]@<a href="'+home+path+'">ŐV</a></b></center>';
        s:='<hr size=1>%d@<br> %d Ԗڂ %d Ԗڂ̋L\<br><center>Page:[<b>';
        result:=Format(s,[ASQLite3Table1.RecordCount,pos*page_def,(pos+1)*page_def-1])+page+foot;
  end;
end;

initialization
  if WebRequestHandler <> nil then
    WebRequestHandler.WebModuleClass := TWebModule2;

end.
