#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include "ibb.h"


gint cb_motion_clist(GtkWidget *, GdkEventMotion *);
gint cb_button_clist(GtkWidget *, GdkEventButton *);


gint cb_motion_clist(GtkWidget *clist, GdkEventMotion *event)
{
  static gint prevRow;
  gint row;
  gint valid;

  valid = gtk_clist_get_selection_info(GTK_CLIST (clist),
				       event->x,
				       event->y,
				       &row,
				       NULL);

  if (valid) {
    if (row != prevRow) {
      gtk_clist_set_background(GTK_CLIST (clist), row,
			       &((clist->style)->bg[0]));
      gtk_clist_set_background(GTK_CLIST (clist), prevRow,
			       &((clist->style)->base[0]));
      prevRow = row;
    }
    else {
      gtk_clist_set_background(GTK_CLIST (clist), row,
			       &((clist->style)->bg[0]));
    }
  }

  return TRUE;
}


gint cb_button_clist(GtkWidget *clist, GdkEventButton *event)
{
  gint row;
  gint valid;
  gchar *url;
  gchar *command;
  gint pid;

  if (event->button == 3) {
    valid = gtk_clist_get_selection_info(GTK_CLIST (clist),
					 event->x,
					 event->y,
					 &row,
					 NULL);

    if (valid) {
      gtk_clist_get_text(GTK_CLIST(clist), row, 1, &url);
      command = g_strconcat(BROWSER, " -remote 'openURL(", url, ")'", NULL);
      if (system(command)) {
	pid = fork();
	if (pid == 0) {
	  execlp(BROWSER, BROWSER, url, 0);
	}
      }
    }

  }
  return TRUE;
}


void add_clistitem(GtkWidget *clist, gchar *dirName)
{
  DIR *dirp;
  struct dirent *entry;
  struct stat statBuf;
  gchar *fileName;
  gchar *fileSuffix;
  gchar *filePath;
  guint fileNameLen;
  FILE *fp;
  gchar urlLine[512];
  gchar *urlData[2];
  GString *urlTemp;

  gtk_clist_clear(GTK_CLIST (clist));

  dirp = opendir(dirName);
  if (dirp == NULL) exit(1);

  while ((entry = readdir(dirp)) != NULL) {

    fileName = entry->d_name;
    fileNameLen = strlen(fileName);
    fileSuffix = fileName + (fileNameLen - 4);

    if (!g_strcasecmp(fileName, ".") || !g_strcasecmp(fileName, "..")) {
      continue;
    }

    filePath = g_strconcat(dirName, "/", fileName, NULL);

    lstat(filePath, &statBuf);
    if (S_ISREG(statBuf.st_mode) && !g_strcasecmp(fileSuffix, ".url")) {
      urlTemp = g_string_new(fileName);
      g_string_erase(urlTemp, urlTemp->len - 4, 4);
      urlData[0] = g_strdup(urlTemp->str);
      fp = fopen(filePath, "r");
      while (fgets(urlLine, 512, fp) != NULL) {
	if (!g_strncasecmp(urlLine, "URL=", 4)) {
	  g_string_assign(urlTemp, urlLine);
	  g_string_erase(urlTemp, 0, 4);
	  urlData[1] = g_strdup(urlTemp->str);
	  gtk_clist_append(GTK_CLIST (clist), urlData);
	  break;
	}
      }
      g_string_free(urlTemp, TRUE);
      fclose(fp);
    }
  }

  closedir(dirp);
}


GtkWidget *make_clist(gchar *dirName)
{
  GtkWidget *scrolled_win;
  GtkWidget *clist;

  gchar *clistTitle[2] = {"Bookmark Name", "URL"};

  /* make scrolled window */
  scrolled_win = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (scrolled_win),
				 GTK_POLICY_AUTOMATIC,
				 GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize(scrolled_win, 300, 300);
  gtk_container_set_border_width (GTK_CONTAINER(scrolled_win), 5);

  /* make clist */
  clist = gtk_clist_new_with_titles(2, clistTitle);
  clistGlobal = clist;

  gtk_widget_set_events(clist, 
			GDK_POINTER_MOTION_MASK |
			GDK_BUTTON_PRESS_MASK);
  gtk_signal_connect(GTK_OBJECT (clist),
		     "motion_notify_event",
		     GTK_SIGNAL_FUNC (cb_motion_clist),
		     NULL);
  gtk_signal_connect(GTK_OBJECT (clist),
		     "button_press_event",
		     GTK_SIGNAL_FUNC (cb_button_clist),
		     NULL);

  gtk_clist_set_selection_mode(GTK_CLIST (clist), GTK_SELECTION_SINGLE);
  gtk_clist_set_column_width(GTK_CLIST (clist), 0, 150);

  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW (scrolled_win),
					clist);


  add_clistitem(clist, dirName);

  gtk_widget_show(clist);
  return(scrolled_win);
}
