#include "ibb.h"


void cb_entry_changed(GtkWidget *, GtkWidget *);


void cb_entry_changed(GtkWidget *entry, GtkWidget *button)
{
  gchar *text;

  text = gtk_entry_get_text(GTK_ENTRY (entry));
  if (!g_strcasecmp(text, "")) {
    gtk_widget_set_sensitive(button, FALSE);
  }
  else {
    gtk_widget_set_sensitive(button, TRUE);
  }

}


void cb_dialog_cancel(GtkWidget *button, GtkWidget *dialog)
{
  gtk_widget_destroy(dialog);
}


GtkWidget *dialog_with_two(GtkWidget *nameEntry, GtkWidget *urlEntry,
			   GtkWidget *okButton, gchar *title)
{
  GtkWidget *dialog;
  GtkWidget *label;
  GtkWidget *noButton;

  dialog = gtk_dialog_new();
  gtk_window_set_modal(GTK_WINDOW (dialog), TRUE);
  gtk_container_set_border_width(GTK_CONTAINER (dialog), 5);
  gtk_window_set_title (GTK_WINDOW (dialog), title);

  label = gtk_label_new("Bookmark Name");
  gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox),
		     label, FALSE, FALSE, 0);
  gtk_widget_show(label);

  /* pack nameEntry */
  gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox),
		     nameEntry, FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT (nameEntry), "changed",
		     GTK_SIGNAL_FUNC (cb_entry_changed),
		     okButton);

  /* insert space */
  label = gtk_label_new(" ");
  gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox),
		     label, FALSE, FALSE, 0);
  gtk_widget_show(label);

  label = gtk_label_new("URL");
  gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox),
		     label, FALSE, FALSE, 0);
  gtk_widget_show(label);

  /* pack urlEntry */
  gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox),
		     urlEntry, FALSE, FALSE, 0);

  /* insert space */
  label = gtk_label_new(" ");
  gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox),
		     label, FALSE, FALSE, 0);
  gtk_widget_show(label);

  /* pack "Ok" button */
  gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->action_area),
		     okButton, TRUE, TRUE, 0);

  noButton = gtk_button_new_with_label("Cancel");
  gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->action_area),
		     noButton, TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT (noButton), "clicked",
		     GTK_SIGNAL_FUNC (cb_dialog_cancel),
		     dialog);
  gtk_widget_show(noButton);

  return(dialog);
}


GtkWidget *dialog_with_one(GtkWidget *nameEntry, GtkWidget *okButton,
			   gchar *title)
{
  GtkWidget *dialog;
  GtkWidget *label;
  GtkWidget *noButton;

  dialog = gtk_dialog_new();
  gtk_window_set_modal(GTK_WINDOW (dialog), TRUE);
  gtk_container_set_border_width(GTK_CONTAINER (dialog), 5);
  gtk_window_set_title (GTK_WINDOW (dialog), title);

  label = gtk_label_new("Folder Name");
  gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox),
		     label, FALSE, FALSE, 0);
  gtk_widget_show(label);

  /* pack nameEntry */
  gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox),
		     nameEntry, FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT (nameEntry), "changed",
		     GTK_SIGNAL_FUNC (cb_entry_changed),
		     okButton);

  /* insert space */
  label = gtk_label_new(" ");
  gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox),
		     label, FALSE, FALSE, 0);
  gtk_widget_show(label);

  /* pack "Ok" button */
  gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->action_area),
		     okButton, TRUE, TRUE, 0);

  noButton = gtk_button_new_with_label("Cancel");
  gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->action_area),
		     noButton, TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT (noButton), "clicked",
		     GTK_SIGNAL_FUNC (cb_dialog_cancel),
		     dialog);
  gtk_widget_show(noButton);

  return(dialog);
}


GtkWidget *dialog_with_label(GtkWidget *okButton,
			     gchar *title, gchar *message)
{
  GtkWidget *dialog;
  GtkWidget *label;
  GtkWidget *noButton;

  dialog = gtk_dialog_new();
  gtk_window_set_modal(GTK_WINDOW (dialog), TRUE);
  gtk_container_set_border_width(GTK_CONTAINER (dialog), 5);
  gtk_window_set_title (GTK_WINDOW (dialog), title);

  label = gtk_label_new(message);
  gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox),
		     label, FALSE, FALSE, 0);
  gtk_widget_show(label);

  /* insert space */
  label = gtk_label_new(" ");
  gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox),
		     label, FALSE, FALSE, 0);
  gtk_widget_show(label);

  /* pack "Ok" button */
  gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->action_area),
		     okButton, TRUE, TRUE, 0);

  noButton = gtk_button_new_with_label("Cancel");
  gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->action_area),
		     noButton, TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT (noButton), "clicked",
		     GTK_SIGNAL_FUNC (cb_dialog_cancel),
		     dialog);
  gtk_widget_show(noButton);

  return(dialog);
}


GtkWidget *dialog_simple(gchar *title, gchar *message)
{
  GtkWidget *dialog;
  GtkWidget *label;
  GtkWidget *noButton;

  dialog = gtk_dialog_new();
  gtk_window_set_modal(GTK_WINDOW (dialog), TRUE);
  gtk_container_set_border_width(GTK_CONTAINER (dialog), 5);
  gtk_window_set_title (GTK_WINDOW (dialog), title);

  label = gtk_label_new(message);
  gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox),
		     label, FALSE, FALSE, 0);
  gtk_widget_show(label);

  noButton = gtk_button_new_with_label("Close");
  gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->action_area),
		     noButton, TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT (noButton), "clicked",
		     GTK_SIGNAL_FUNC (cb_dialog_cancel),
		     dialog);
  gtk_widget_show(noButton);

  return(dialog);
}
