#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include "ibb.h"


void cb_about(GtkWidget *toolBar, gpointer data)
{
  GtkWidget *dialog;
  gchar *message;

  message = g_strconcat("IBB Version ", VERSION,
			"\nTeppei Kaku <teppei@sat.co.jp>\n\n",
			"This software comes with ABSOLUTELY NO WARRANTY.\n",
			"Please use AT YOUR OWN LISK.\n", NULL);

  dialog = dialog_simple("IBB: About", message);
  gtk_widget_show(dialog);
}


void cb_select_treeitem(GtkWidget *item, gchar *dirName)
{
  dirNameGlobal = g_strdup(dirName);
  add_clistitem(clistGlobal, dirName);
}


GtkWidget *make_tree(gchar *dirName)
{
  GtkWidget *scrolled_win;
  GtkWidget *tree;
  GtkWidget *item;

  struct stat statBuf;

  /* make scrolled window */
  scrolled_win = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (scrolled_win),
				 GTK_POLICY_AUTOMATIC,
				 GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize(scrolled_win, 200, 300);
  gtk_container_set_border_width (GTK_CONTAINER(scrolled_win), 5);

  /* make tree */
  tree = gtk_tree_new();
  treeGlobal = tree;
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW (scrolled_win),
					tree);
  gtk_tree_set_selection_mode(GTK_TREE (tree), GTK_SELECTION_SINGLE);
  gtk_tree_set_view_lines(GTK_TREE (tree), FALSE);
  gtk_widget_show(tree);

  /* make root tree item */
  lstat(dirName, &statBuf);
  if (S_ISDIR(statBuf.st_mode)) {
    item = gtk_tree_item_new_with_label(g_basename(dirName));

    gtk_signal_connect(GTK_OBJECT (item), "select",
		       GTK_SIGNAL_FUNC (cb_select_treeitem),
		       dirName);

    gtk_tree_append (GTK_TREE (tree), item);
    gtk_widget_show (item);
    make_subtree(tree, item, dirName);

    gtk_tree_item_expand(GTK_TREE_ITEM (item));
  }
  return(scrolled_win);
}


void make_subtree(GtkWidget *parentTree, GtkWidget *parentItem,
		  gchar *dirName)
{
  GtkWidget *tree;

  DIR *dirp;
  gchar *baseName;
  gchar *newDirName;
  struct dirent *entry;
  struct stat statBuf;
  guint treeFlag = 0;

  dirp = opendir(dirName);
  if (dirp == NULL) {
    exit(1);
  }

  while ((entry = readdir(dirp)) != NULL) {

    GtkWidget *item;
    baseName = entry->d_name;

    if (!g_strcasecmp(baseName, ".") || !g_strcasecmp(baseName, "..")) {
      continue;
    }

    newDirName = g_strconcat(dirName, "/", baseName, NULL);

    lstat(newDirName, &statBuf);
    if (S_ISDIR (statBuf.st_mode)) {
      if (!treeFlag) {
	tree = gtk_tree_new();
	gtk_tree_item_set_subtree (GTK_TREE_ITEM (parentItem), tree);
	treeFlag = 1;
      }

      item = gtk_tree_item_new_with_label (baseName);
      gtk_signal_connect(GTK_OBJECT (item), "select",
			 GTK_SIGNAL_FUNC (cb_select_treeitem), newDirName);

      gtk_tree_append (GTK_TREE(tree), item);
      gtk_widget_show (item);
      make_subtree(tree, item, newDirName);
    }
  }

  closedir(dirp);
}  


gchar *arg_parse(guint argc, gchar *argv[])
{
  GString *dirName;
  gchar *newDirName;
  DIR *dirp;

  if (argc == 2) {
    dirName = g_string_new(argv[1]);
    if (*(dirName->str + dirName->len - 1) == '/') {
      g_string_erase(dirName, dirName->len - 1, 1);
    }
    newDirName = g_strdup(dirName->str);
    g_string_free(dirName, TRUE);
    dirp = opendir(newDirName);
    if (dirp == NULL) {
      g_print("ERROR: Unable to load the directory!\n");
      exit(1);
    }
    closedir(dirp);
    return(newDirName);
  }
  else {
    g_print("Usage: ibb <path to directory>\n");
    exit(1);
  }
}


int main(int argc, char *argv[])
{
  GtkWidget *window;
  GtkWidget *box;
  GtkWidget *hpaned;
  GtkWidget *treePain;
  GtkWidget *urlPain;
  GtkWidget *toolBar;
  GtkWidget *separator;
  gchar *dirName;

  gtk_set_locale();
  gtk_init(&argc, &argv);

  dirName = arg_parse(argc, argv);
  dirNameGlobal = g_strdup(dirName);

  /* make window */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_signal_connect (GTK_OBJECT(window), "delete_event",
                      GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
  gtk_signal_connect (GTK_OBJECT(window), "destroy",
                      GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
  gtk_window_set_title (GTK_WINDOW (window),
			g_strconcat("IBB Version ", VERSION, NULL));

  /* make toolbar */
  toolBar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL,
			    GTK_TOOLBAR_ICONS);
  gtk_container_set_border_width(GTK_CONTAINER (toolBar), 5);
  gtk_widget_show(toolBar);

  /* make separator */
  separator = gtk_hseparator_new ();
  gtk_widget_show (separator);
  
  /* make paned window */
  hpaned = gtk_hpaned_new();
  gtk_widget_show(hpaned);

  treePain = make_tree(dirName);
  gtk_paned_add1(GTK_PANED (hpaned), treePain);
  gtk_widget_show(treePain);

  urlPain = make_clist(dirName);
  gtk_paned_add2(GTK_PANED (hpaned), urlPain);
  gtk_widget_show(urlPain);

  /* make packing box */
  box = gtk_vbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX (box), toolBar, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX (box), separator, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX (box), hpaned, TRUE, TRUE, 0);
  gtk_container_add(GTK_CONTAINER (window), box);
  gtk_widget_show(box);

  gtk_widget_show(window);

  make_toolbar(window, toolBar);

  gtk_main();

  exit(0);
}
