/*
-------------------------------------------------------------------------------
  edit.c - Edit folder or bookmark
-------------------------------------------------------------------------------
*/
#include "ibb.h"


typedef struct {
  GtkWidget *dialog;
  GtkWidget *nameEntry;
  GtkWidget *urlEntry;
  gchar *fileName;
  gchar *urlName;
} typeEdit;


void edit_folder_ok(GtkWidget *, typeEdit *);
void edit_bookmark_ok(GtkWidget *, typeEdit *);


/*
-------------------------------------------------------------------------------
  Edit bookmark
-------------------------------------------------------------------------------
*/
void edit_bookmark_ok(GtkWidget *button, typeEdit *data)
{
}


/*
-------------------------------------------------------------------------------
  Edit folder
-------------------------------------------------------------------------------
*/
void edit_folder_ok(GtkWidget *button, typeEdit *data)
{
}


/*
-------------------------------------------------------------------------------
  Popup "Edit Folder" dialog
-------------------------------------------------------------------------------
*/
void cb_edit_folder(GtkWidget *widget, gpointer data)
{
  GtkWidget *dialog;
  GtkWidget *nameEntry;
  GtkWidget *okButton;
  GList *selection;
  typeEdit *passData;

  selection = GTK_TREE_SELECTION (treeGlobal);

  if (!selection) {
    error_dialog("ERROR: Select a folder!\n");
    return;
  }

  passData = g_malloc(sizeof(typeEdit));
  nameEntry = gtk_entry_new();
  gtk_entry_set_text(GTK_ENTRY (nameEntry),
		     g_basename(dirNameGlobal));
  gtk_entry_select_region(GTK_ENTRY (nameEntry), 0, -1);
  okButton = gtk_button_new_with_label("Ok");
  dialog = dialog_with_one(nameEntry, okButton, "IBB: Edit Folder");

  passData->dialog = dialog;
  passData->nameEntry = nameEntry;

  gtk_signal_connect(GTK_OBJECT (okButton), "clicked",
		     GTK_SIGNAL_FUNC (edit_folder_ok),
		     passData);

  gtk_widget_show(nameEntry);
  gtk_widget_show(okButton);
  gtk_widget_show(dialog);
  gtk_widget_grab_focus(nameEntry);
}


/*
-------------------------------------------------------------------------------
  Popup "Edit Bookmark" dialog
-------------------------------------------------------------------------------
*/
void cb_edit_bookmark(GtkWidget *widget, gpointer data)
{
  GtkWidget *dialog;
  GtkWidget *nameEntry;
  GtkWidget *urlEntry;
  GtkWidget *okButton;
  GList *selection;
  typeEdit *passData;
  gchar *fileName;
  gchar *urlName;

  selection = GTK_CLIST (clistGlobal)->selection;
  if (!selection) {
    error_dialog("ERROR: Select a bookmark!\n");
    return;
  }

  passData = g_malloc(sizeof(typeEdit));

  nameEntry = gtk_entry_new();
  urlEntry = gtk_entry_new();

  gtk_clist_get_text(GTK_CLIST (clistGlobal),
		     GPOINTER_TO_INT (selection->data), 0, &fileName);
  gtk_clist_get_text(GTK_CLIST (clistGlobal),
		     GPOINTER_TO_INT (selection->data), 1, &urlName);

  gtk_entry_set_text(GTK_ENTRY (nameEntry), fileName);
  gtk_entry_set_text(GTK_ENTRY (urlEntry), urlName);
  gtk_entry_select_region(GTK_ENTRY (nameEntry), 0, -1);
  gtk_entry_select_region(GTK_ENTRY (urlEntry), 0, -1);

  okButton = gtk_button_new_with_label("Ok");
  dialog = dialog_with_two(nameEntry, urlEntry, okButton,
			   "IBB: Edit Bookmark");

  passData->dialog = dialog;
  passData->nameEntry = nameEntry;
  passData->urlEntry = urlEntry;
  passData->fileName = g_strdup(fileName);
  passData->urlName = g_strdup(urlName);
  gtk_signal_connect(GTK_OBJECT (okButton), "clicked",
		     GTK_SIGNAL_FUNC (edit_bookmark_ok),
		     passData);

  gtk_widget_show(nameEntry);
  gtk_widget_show(urlEntry);
  gtk_widget_show(okButton);
  gtk_widget_show(dialog);
  gtk_widget_grab_focus(nameEntry);

  g_free(fileName);
  g_free(urlName);
}
