/*
-------------------------------------------------------------------------------
  new.c - Create new folder or bookmark
-------------------------------------------------------------------------------
*/


#include <stdio.h>
#include <sys/stat.h>
#include "ibb.h"


typedef struct {
  GtkWidget *dialog;
  GtkWidget *nameEntry;
  GtkWidget *urlEntry;
} typeNew;


void new_bookmark_ok(GtkWidget *, typeNew *);
void new_folder_ok(GtkWidget *, typeNew *);


/*
-------------------------------------------------------------------------------
  Create new folder
-------------------------------------------------------------------------------
*/
void new_folder_ok(GtkWidget *button, typeNew *data)
{
  gchar *fileTemp;
  gchar *fileName;
  GtkWidget *tree;
  GtkWidget *item;
  GtkWidget *subtree;
  GList *selection;
  FILE *fp;

  fileTemp = gtk_entry_get_text(GTK_ENTRY (data->nameEntry));

  if (!g_strcasecmp(fileTemp, "")) {
    error_dialog("ERROR: Fill folder name!\n");
    return;
  }
  if (!filename_check(fileTemp)) {
    error_dialog("ERROR: Bad file name!\n");
    return;
  }

  fileName = g_strconcat(dirNameGlobal, "/", fileTemp, NULL);

  fp = fopen(fileName, "r");
  if (fp != NULL) {
    error_dialog("ERROR: File already exists!\n");
    fclose(fp);
    return;
  }

  mkdir(fileName, 755);

  selection = GTK_TREE_SELECTION (treeGlobal);
  subtree = GTK_TREE_ITEM_SUBTREE (selection->data);

  if (!subtree) {
    tree = gtk_tree_new();
    gtk_tree_item_set_subtree(GTK_TREE_ITEM (selection->data), tree);
    gtk_widget_show(tree);
  }
  else {
    tree = subtree;
  }

  item = gtk_tree_item_new_with_label (fileTemp);
  gtk_signal_connect(GTK_OBJECT (item), "select",
		     GTK_SIGNAL_FUNC (cb_select_treeitem), fileName);
  gtk_tree_append (GTK_TREE(tree), item);
  gtk_widget_show (item);
  gtk_tree_item_expand(GTK_TREE_ITEM (selection->data));

  gtk_widget_destroy(data->dialog);
  g_free(data);
  return;
}


/*
-------------------------------------------------------------------------------
  Create new bookmark
-------------------------------------------------------------------------------
*/
void new_bookmark_ok(GtkWidget *button, typeNew *data)
{
  gchar *fileTemp;
  gchar *urlTemp;
  gchar *fileName;
  gchar *urlName;
  gchar *urlData[2];

  FILE *fp;
  FILE *rfp;

  fileTemp = gtk_entry_get_text(GTK_ENTRY (data->nameEntry));
  urlTemp = gtk_entry_get_text(GTK_ENTRY (data->urlEntry));

  if (!g_strcasecmp(fileTemp, "") || !g_strcasecmp(urlTemp, "")) {
    error_dialog("ERROR: Fill bookmark name and URL!\n");
    return;
  }
  if (!filename_check(fileTemp)) {
    error_dialog("ERROR: Bad file name!\n");
    return;
  }

  fileName = g_strconcat(dirNameGlobal, "/", fileTemp, ".url", NULL);
  urlName = g_strconcat("URL=", urlTemp, NULL);

  rfp = fopen(fileName, "r");
  if (rfp == NULL) {
    fp = fopen(fileName, "w");
    if (fp != NULL) {
      fputs("[InternetShortcut]\r\n", fp);
      fputs(urlName, fp);
      fputs("\r\n", fp);
      fclose(fp);

      urlData[0] = fileTemp;
      urlData[1] = urlTemp;
      gtk_clist_append(GTK_CLIST (clistGlobal), urlData);

      gtk_widget_destroy(data->dialog);
      g_free(data);
      return;
    }
    else {
      error_dialog("ERROR: Cannot open the file!\n");
      return;
    }
  }
  else {
    error_dialog("ERROR: File already exists!\n");
    fclose(rfp);
    return;
  }
}


/*
-------------------------------------------------------------------------------
  Popup "New Bookmark" dialog
-------------------------------------------------------------------------------
*/
void cb_new_bookmark(GtkWidget *widget, gpointer data)
{
  GtkWidget *dialog;
  GtkWidget *nameEntry;
  GtkWidget *urlEntry;
  GtkWidget *okButton;
  GList *selection;
  typeNew *passData;

  selection = GTK_TREE_SELECTION (treeGlobal);
  if (!selection) {
    error_dialog("ERROR: Select a folder!\n");
    return;
  }

  passData = g_malloc(sizeof(typeNew));

  nameEntry = gtk_entry_new();
  urlEntry = gtk_entry_new();
  gtk_entry_set_text(GTK_ENTRY (urlEntry), "http://");
  okButton = gtk_button_new_with_label("Ok");
  gtk_widget_set_sensitive(okButton, FALSE);
  dialog = dialog_with_two(nameEntry, urlEntry, okButton,
			   "IBB: New Bookmark");

  passData->dialog = dialog;
  passData->nameEntry = nameEntry;
  passData->urlEntry = urlEntry;
  gtk_signal_connect(GTK_OBJECT (okButton), "clicked",
		     GTK_SIGNAL_FUNC (new_bookmark_ok),
		     passData);

  gtk_widget_show(nameEntry);
  gtk_widget_show(urlEntry);
  gtk_widget_show(okButton);
  gtk_widget_show(dialog);
  gtk_widget_grab_focus(nameEntry);
}


/*
-------------------------------------------------------------------------------
  Popup "New Folder" dialog
-------------------------------------------------------------------------------
*/
void cb_new_folder(GtkWidget *widget, gpointer data)
{
  GtkWidget *dialog;
  GtkWidget *nameEntry;
  GtkWidget *okButton;
  GList *selection;
  typeNew *passData;

  selection = GTK_TREE_SELECTION (treeGlobal);

  if (!selection) {
    error_dialog("ERROR: Select a folder!\n");
    return;
  }

  passData = g_malloc(sizeof(typeNew));

  nameEntry = gtk_entry_new();
  okButton = gtk_button_new_with_label("Ok");
  gtk_widget_set_sensitive(okButton, FALSE);
  dialog = dialog_with_one(nameEntry, okButton, "IBB: New Folder");

  passData->dialog = dialog;
  passData->nameEntry = nameEntry;
  gtk_signal_connect(GTK_OBJECT (okButton), "clicked",
		     GTK_SIGNAL_FUNC (new_folder_ok),
		     passData);

  gtk_widget_show(nameEntry);
  gtk_widget_show(okButton);
  gtk_widget_show(dialog);
  gtk_widget_grab_focus(nameEntry);
}
