/*
-------------------------------------------------------------------------------
  toolbar.c - Create toolbar and popup menu
-------------------------------------------------------------------------------
*/


#include "ibb.h"

#include "images/toolbar-new.xpm"
#include "images/toolbar-edit.xpm"
#include "images/toolbar-trash.xpm"
#include "images/toolbar-move.xpm"
#include "images/toolbar-about.xpm"
#include "images/toolbar-exit.xpm"


void popup_new(void);
void popup_edit(void);
void popup_delete(void);


/*
-------------------------------------------------------------------------------
  Create toolbar
-------------------------------------------------------------------------------
*/
void make_toolbar(GtkWidget *window, GtkWidget *toolBar)
{
  GdkPixmap *image;
  GdkBitmap *mask;
  GtkWidget *icon;
  GtkWidget *button;

  image = gdk_pixmap_create_from_xpm_d(window->window, &mask,
				       &window->style->white,
				       toolbar_new_xpm);
  icon = gtk_pixmap_new(image, mask);
  button = gtk_toolbar_append_item(GTK_TOOLBAR (toolBar),
				      "New",
				      "New",
				      "New",
				      icon,
				      GTK_SIGNAL_FUNC (popup_new),
				      NULL);

  image = gdk_pixmap_create_from_xpm_d(window->window, &mask,
				       &window->style->white,
				       toolbar_edit_xpm);
  icon = gtk_pixmap_new(image, mask);
  button = gtk_toolbar_append_item(GTK_TOOLBAR (toolBar),
				      "Edit",
				      "Edit",
				      "Edit",
				      icon,
				      GTK_SIGNAL_FUNC (popup_edit),
				      NULL);

  image = gdk_pixmap_create_from_xpm_d(window->window, &mask,
				       &window->style->white,
				       toolbar_trash_xpm);
  icon = gtk_pixmap_new(image, mask);
  button = gtk_toolbar_append_item(GTK_TOOLBAR (toolBar),
				      "Delete",
				      "Delete",
				      "Delete",
				      icon,
				      GTK_SIGNAL_FUNC (popup_delete),
				      NULL);

  gtk_toolbar_append_space(GTK_TOOLBAR (toolBar));
  gtk_toolbar_append_space(GTK_TOOLBAR (toolBar));

  image = gdk_pixmap_create_from_xpm_d(window->window, &mask,
				       &window->style->white,
				       toolbar_move_xpm);
  icon = gtk_pixmap_new(image, mask);
  button = gtk_toolbar_append_item(GTK_TOOLBAR (toolBar),
				      "Move Bookmark",
				      "Move Bookmark",
				      "Move Bookmark",
				      icon,
				      GTK_SIGNAL_FUNC (cb_about),
				      NULL);

  gtk_toolbar_append_space(GTK_TOOLBAR (toolBar));
  gtk_toolbar_append_space(GTK_TOOLBAR (toolBar));

  image = gdk_pixmap_create_from_xpm_d(window->window, &mask,
				       &window->style->white,
				       toolbar_about_xpm);
  icon = gtk_pixmap_new(image, mask);
  button = gtk_toolbar_append_item(GTK_TOOLBAR (toolBar),
				      "About IBB",
				      "About IBB",
				      "About IBB",
				      icon,
				      GTK_SIGNAL_FUNC (cb_about),
				      NULL);

  image = gdk_pixmap_create_from_xpm_d(window->window, &mask,
				       &window->style->white,
				       toolbar_exit_xpm);
  icon = gtk_pixmap_new(image, mask);
  button = gtk_toolbar_append_item(GTK_TOOLBAR (toolBar),
				      "Exit IBB",
				      "Exit IBB",
				      "Exit IBB",
				      icon,
				      GTK_SIGNAL_FUNC (gtk_main_quit),
				      NULL);
}


/*
-------------------------------------------------------------------------------
  "New" menu
-------------------------------------------------------------------------------
*/
void popup_new()
{
  GtkWidget *menu;
  GtkWidget *menuItem;

  menu = gtk_menu_new();

  menuItem = gtk_menu_item_new_with_label("Folder...");
  gtk_signal_connect(GTK_OBJECT (menuItem), "activate",
		      GTK_SIGNAL_FUNC (cb_new_folder), NULL);
  gtk_menu_append(GTK_MENU (menu), menuItem);
  gtk_widget_show(menuItem);

  menuItem = gtk_menu_item_new_with_label("Bookmark...");
  gtk_signal_connect(GTK_OBJECT (menuItem), "activate",
		      GTK_SIGNAL_FUNC (cb_new_bookmark), NULL);
  gtk_menu_append(GTK_MENU (menu), menuItem);
  gtk_widget_show(menuItem);

  gtk_menu_popup(GTK_MENU (menu), NULL, NULL, NULL, NULL, 0, 0);
}


/*
-------------------------------------------------------------------------------
  "Edit" menu
-------------------------------------------------------------------------------
*/
void popup_edit()
{
  GtkWidget *menu;
  GtkWidget *menuItem;

  menu = gtk_menu_new();

  menuItem = gtk_menu_item_new_with_label("Folder...");
  gtk_signal_connect(GTK_OBJECT (menuItem), "activate",
		      GTK_SIGNAL_FUNC (cb_edit_folder), NULL);
  gtk_menu_append(GTK_MENU (menu), menuItem);
  gtk_widget_show(menuItem);

  menuItem = gtk_menu_item_new_with_label("Bookmark...");
  gtk_signal_connect(GTK_OBJECT (menuItem), "activate",
		      GTK_SIGNAL_FUNC (cb_edit_bookmark), NULL);
  gtk_menu_append(GTK_MENU (menu), menuItem);
  gtk_widget_show(menuItem);

  gtk_menu_popup(GTK_MENU (menu), NULL, NULL, NULL, NULL, 0, 0);
}


/*
-------------------------------------------------------------------------------
  "Delete" menu
-------------------------------------------------------------------------------
*/
void popup_delete()
{
  GtkWidget *menu;
  GtkWidget *menuItem;

  menu = gtk_menu_new();

  menuItem = gtk_menu_item_new_with_label("Folder...");
  gtk_signal_connect(GTK_OBJECT (menuItem), "activate",
		      GTK_SIGNAL_FUNC (cb_delete_folder), NULL);
  gtk_menu_append(GTK_MENU (menu), menuItem);
  gtk_widget_show(menuItem);

  menuItem = gtk_menu_item_new_with_label("Bookmark...");
  gtk_signal_connect(GTK_OBJECT (menuItem), "activate",
		      GTK_SIGNAL_FUNC (cb_delete_bookmark), NULL);
  gtk_menu_append(GTK_MENU (menu), menuItem);
  gtk_widget_show(menuItem);

  gtk_menu_popup(GTK_MENU (menu), NULL, NULL, NULL, NULL, 0, 0);
}
