/*
  ^[~i\tg
  Satofumi KAMIMURA
  $Id$
*/

#include "StandardInput.h"
#include "SerialCtrl.h"
#include "SearchFilePath.h"
#include "FileToArgs.h"
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <string>
#include <vector>


static const char* DefaultDevice = "/dev/usb/ttyUSB0";
static const long DefaultBaudrate = 115200;

/*!
  \brief miniterm ̈Ǘ
*/
class ArgsInfo {
public:
  std::string device;
  long baudrate;

  ArgsInfo(void) : device(DefaultDevice), baudrate(DefaultBaudrate) {
  }
};

static void printHelp(char *progName, const char* device, long baudrate) {
  printf("using:\n"
	 "\t%s [--port=%s] [-b=%ld]\n\n",
	 progName, device, baudrate);
}


static void parseArgs(ArgsInfo& args_info, int argc, char* argv[]) {

  for (int i = 1; i < argc; ++i) {
    if (! strncmp("--port=", argv[i], 7)) {
      args_info.device = &argv[i][7];

    } else if (! strncmp("-b=", argv[i], 3)) {
      args_info.baudrate = atoi(&argv[i][3]);

    } else if ((! strcmp("--help", argv[i])) || (! strcmp("-h", argv[i]))) {
      printHelp(argv[0], args_info.device.c_str(), args_info.baudrate);
      exit(1);
    }
  }
}


int main(int argc, char *argv[]) {

  // ݒt@C̓ǂݏo
  std::vector<std::string> search_path;
  search_path.push_back(".");
  search_path.push_back("~/.beego/");

  ArgsInfo args_info;
  std::string config_file;
  if (searchFilePath(config_file, "beegoconf", search_path)) {
    FileToArgs file;
    file.load(config_file.c_str());
    // ݒt@C̓eƂĈ
    parseArgs(args_info, file.argc, file.argv);
  }
  // nꂽ̕]
  parseArgs(args_info, argc, argv);

  // VAڑJ
  SerialCtrl con;
  int ret_value = con.connect(args_info.device.c_str(), args_info.baudrate);
  if (ret_value < 0) {
    printf("%s\n", con.what());
    exit(1);
  }

  // W͂ւ̐ڑJ
  StandardInput sto;

  // ʐM
  char buf[BUFSIZ];
  while (1) {
    int n = con.recv(buf, BUFSIZ, 0);
    if (n > 0) {
      write(1, buf, n);
    }
    n = sto.recv(buf, BUFSIZ, 10);
    if (n > 0) {
      con.send(buf, n);
    }
  }

  return 0;
}
