#!/usr/bin/perl
#==========================================================================#
#  B.Forum a2b.pl Ver.1.01                                               #
#  Hiroaki,Sakuma (sakuma@beetas.org)                                    #
#                                                                          #
# Υץꥱϥץ󥽡Ǥ.                          #
# ̵ǻѤ뤳ȤǤޤ.                                            #
# ʤ, ܺ٤ʻѾ/ǿˤĤƤϲȤ.           #
# http://www.beetas.org/                                                   #
#                                                                          #
# ------------------------------------------------------------------------ #
# Copyright 2002 Hiroaki,Sakuma All Rights Reserved.                       #
# Copyright 2002 BEETAS.org All Rights Reserved.                           #
#                                                                          #
#==========================================================================#
package a2b;

$version = '1.01-3';
$revision = '1.01.0004';
$rcfile = '.bforumrc';

unshift (@INC,'.');

use Bforum;

&main;

sub main {

	$start = (times)[0];

	&decode;

	&Bforum::setting(\%SET,"./$rcfile","$ENV{'HOME'}/$rcfile");
	&Bforum::_path($SET{'USER_DIR'});

	$in{'h'} ||= $in{'help'};
	$in{'d'} ||= $in{'delete'};
	$in{'v'} ||= $in{'version'};

	if ($in{'v'}) {
		&version;
		exit;
	} elsif ($in{'h'} || !%in) {
		&version;
		&usage;
		exit;
	}

	if ($in{'mknmz'}) { $SET{'MKNMZ'} = $in{'mknmz'}; }
	$SET{'MKNMZ'} =~ s/\\/\\\\/g;

	&version;
	if ($in{'id'}) {
		if ($in{'r'}) {
			&reflexive("$SET{'USER_DIR'}/$in{'id'}");
		} else {
			&init("$SET{'USER_DIR'}/$in{'id'}");
		}
	} else {
		&reflexive("$SET{'USER_DIR'}");
	}
	&finish;

}

sub usage {
	$print = <<"END";
Ȥ:

ޤ, bforum.cgiBForum.pmΤǥ쥯ȥذưޤ.

\$ ./a2b.pl [-ץ] оݥ

-r            ƵŪ˥ǥ쥯ȥ򸡺, оݰʲΥǥ쥯ȥˤ
              ƤΥȤоݤˤޤ.
-d            ֲեϺޤ.
--charset="." åʸɤꤷޤ. ɸeucǤ.
              ǤΤ'euc','sjis','jis'Ǥ.

 *** оݥȤάƤΥȤоݤˤʤޤ. ***

:

\$ cd cgi-bin
\$ ./a2b.pl -r Account

\[Win32\]
C:\\web\\cgi-bin\\bforum> a2b.pl --charset=sjis -r Account
END
	print code($print);
}

sub version {
	printf ("%1s%-74s%1s\n","#",("=" x 74),"#");
	printf code("%1s%-74s%1s\n","#","  B.Forum a2b.pl Ver.$version($revision)","#");
	printf code("%1s%-74s%1s\n","#","  Hiroaki,Sakuma (sakuma\@beetas.org)","#");
	printf ("%1s%-74s%1s\n","#"," ","#");
	printf ("%1s%-74s%1s\n","#"," This is free software.","#");
	printf ("%1s%-74s%1s\n","#"," You can use of free.","#");
	printf ("%1s%-74s%1s\n","#"," See the our webpage for more details and news.","#");
	printf ("%1s%-74s%1s\n","#"," http://www.beetas.org/","#");
	printf ("%1s%-74s%1s\n","#"," ","#");
	printf ("%1s %-72s %1s\n","#",("-" x 72),"#");
	printf ("%1s%-74s%1s\n","#"," Copyright 2002 Hiroaki,Sakuma All Rights Reserved.","#");
	printf ("%1s%-74s%1s\n","#"," Copyright 2002 BEETAS.org All Rights Reserved.","#");
	printf ("%1s%-74s%1s\n","#"," ","#");
	printf ("%1s%-74s%1s\n","#",("=" x 74),"#");
	print "\n";
}

sub finish {
	print "\n";
	printf ("%1s%-74s%1s\n","#",("=" x 74),"#");
	printf code("%1s%-20s%30s  %-22s%1s\n","#","  Time",sprintf("%.2f",((times)[0] - $start)),"sec.","#");
	printf code("%1s%-20s%30s  %-22s%1s\n","#","  Account","$account",undef,"#");
	printf code("%1s%-20s%30s  %-22s%1s\n","#","  Directory","$dir",undef,"#");
	printf code("%1s%-20s%30s  %-22s%1s\n","#","  Files","$files",undef,"#");
	printf ("%1s%-74s%1s\n","#",("=" x 74),"#");
	exit;
}

sub comma {
	my ($tmp1);
	my (@tmp2);
	$tmp1 = $_[0];
	if (!$tmp1) { return "0"; }
	while ($tmp1) {
		unshift (@tmp2,substr($tmp1,-3,3,undef));
	}
	return join(',',@tmp2);
}

sub code {
	undef $tmp2;

	@tmp2 = @_;

	if ($in{'charset'}) {
		if (!$init{'code'}) {
			if ($SET{'NKF'}) {
				eval("use $SET{'NKF'}");
			} elsif ($SET{'JCODE'}) {
				require $SET{'JCODE'} || &error(__LINE__ . '@' . __FILE__);
			}
			$init{'code'} = 1;
		}

		if ($init{'code'}) {

			$tmp1 = $in{'charset'};

			foreach (@tmp2) {
				if ($_ =~ /\w/) {
					if ($SET{'NKF'}) {
						$$tmp1 = NKF::nkf("--$tmp1",$_);
					} elsif ($SET{'JCODE'}) {
						jcode::convert(\$_,$tmp1,'euc','z');
					}
				}
			}

		}

	}

	return @tmp2;

}

sub reflexive {
	local ($open) = $_[0];

	local (@files,$path);
	opendir (DIR,$open);
	@files = readdir(DIR);
	closedir (DIR);
	foreach $path (@files) {
		if ($path eq '.' || $path eq '..') { next; }
		if ($path eq 'index') {
			$in{'id'} = $open;
			$in{'id'} =~ s/^$SET{'USER_DIR'}\///g;
			&init("$SET{'USER_DIR'}/$in{'id'}");
		}
		$path = "$open/$path";
		if (-d $path) { &reflexive($path); }
	}
}

sub init {
	&Bforum::setting(\%SET,"$_[0]/$rcfile");
	&Bforum::_path($SET{'USER_DIR'});
	printf ("%-76s","=>$in{'id'}");

	&search($_[0]);

	print ("\b" x 76);
	printf ("=>$in{'id'}\[Complete\]%-" . (76 -(length($in{'id'})) - 12) . "s\n",undef);

}

sub search {

	if (-f "$_[0]/index") {
		$account++;
		$tmp1 = @tmp = &Bforum::_open('file',"$_[0]/index");
		undef $tmp2;
		foreach (@tmp) {
			$in{'t'} = $_;
			chomp $in{'t'};

			if (-d "$_[0]/$in{'t'}" || -f "$_[0]/$in{'t'}.0.bfa") {
				undef $tmp3;
				while (1) {

					$tmp3 ++;

					undef %search;
					&Bforum::_analysis(\%search,&Bforum::_open(undef,"$_[0]/$in{'t'}/$tmp3"));
				if ($in{'d'}) { unlink("$_[0]/$in{'t'}." . ($tmp3 / 10) . ".bfa"); }


					if (!$search{'message'}) { last; }
					if ($search{'delete'}) { next; }

					$files++;
					if (!-f "$_[0]/$in{'t'}/$tmp3") {
						if (!-d "$_[0]/$in{'t'}") {
							umask (000);
							mkdir ("$_[0]/$in{'t'}",0777) || &error(__LINE__ . '@' . __FILE__);
						}
						open (TMP,">$_[0]/$in{'t'}/$tmp3");
						binmode (TMP);
						print TMP &Bforum::_open(undef,"$_[0]/$in{'t'}/$tmp3");
						close (TMP);
					}
					utime ($search{'date'},$search{'date'},"$_[0]/$in{'t'}/$tmp3");
				}

				foreach $tmp3 ('list','last') {
					@tmp5 = &Bforum::_open(undef,"$_[0]/$in{'t'}/$tmp3");
					if (join('',@tmp5)) {
						open (TMP,">$_[0]/$in{'t'}/$tmp3");
						binmode (TMP);
						print TMP @tmp5;
						close (TMP);
						utime ($search{'date'},$search{'date'},"$_[0]/$in{'t'}/$tmp3");
					}
					undef @tmp5;
				}

				if ($in{'d'}) { unlink("$_[0]/$in{'t'}.0.bfa"); }

			}

			$tmp2++;
			print ("\b" x 76);
			printf ("=>$in{'id'}\[%s\]#%-" . (76 -(length("$in{'id'}$in{'t'}")) - 10) . "s#%3d\%", "$in{'t'}",('=' x (int($tmp2 * (76 - (length("$in{'id'}$in{'t'}")) - 10) / $tmp1))),(int(100 * $tmp2 / $tmp1)));
		}
		$dir += $tmp2;
	}

}

sub decode {
	my ($buffer);
	if ($ENV{'REQUEST_METHOD'} eq "POST") {
		read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
	} else { $buffer = $ENV{'QUERY_STRING'}; }
	if (!$buffer) { $buffer = $ARGV[0]; }
	foreach (@ARGV) {
		if ($_ =~ /^--(\S*)=(\S*)$/) {
			$in{$1} = $2;
		} elsif ($_ =~ /^--(\S*)$/) {
			$in{$1} = 1;
		} elsif ($_ =~ /^-(\S*)$/) {
			foreach (split(//,$1)) {
				$in{$_} = 1;
			}
		} else {
			$in{'id'} = $_;
		}
	}

	undef @_;
}


sub error {
	print "\nError:" . $_[0];
	undef @_;
	exit;
}

