/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.tm.ui.actions;

import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

import benten.cat.tm.core.BentenTmSearchResult;
import benten.cat.tm.ui.CatTmUiPlugin;
import benten.cat.tm.ui.actions.messages.ShowTranslationActionMessages;
import benten.cat.tm.ui.views.TranslationView;
import benten.ui.UiPlugin;
import benten.ui.UiStatus;

/**
 * 翻訳ビュー表示アクション。
 * <p>
 * ★基本設計「翻訳支援機能: 翻訳メモリー検索機能」に対応します。
 *
 * @author YAMAMOTO Koji
 * @author KASHIHARA Shinji
 */
public class ShowTranslationAction implements IEditorActionDelegate {

	/**
	 * 翻訳メモリー検索結果を表示するビューのためのメッセージ。
	 */
	protected static final ShowTranslationActionMessages fMsg = new ShowTranslationActionMessages();

	/**
	 * ターゲットとなるエディター
	 */
	private IEditorPart targetEditor;

	/**
	 * 選択
	 */
	private ISelection selection;

	/**
	 * {@inheritDoc}
	 */
	public void selectionChanged(final IAction action, final ISelection selection) {
		this.selection = selection;
	}

	/**
	 * {@inheritDoc}
	 */
	public void setActiveEditor(final IAction action, final IEditorPart targetEditor) {
		this.targetEditor = targetEditor;
	}

	/**
	 * {@inheritDoc}
	 */
	public void run(final IAction action) {
		try {
			// エンジンが取得できることを予め確認。
			CatTmUiPlugin.getDefault().getTmEngine();
		} catch (final IllegalArgumentException e) {
			final UiStatus s = new UiStatus(IStatus.ERROR, e.getMessage());
			UiPlugin.openDialog(fMsg.getMsg001(), s);
			return;
		}

		final String text = ((ITextSelection) selection).getText();
		final TableViewer viewer = showView().getViewer();

		final Job job = new Job(fMsg.getJobName()) {
			@Override
			protected IStatus run(final IProgressMonitor monitor) {
				monitor.beginTask(null, IProgressMonitor.UNKNOWN);
				if (monitor.isCanceled()) {
					return Status.CANCEL_STATUS;
				}
				final List<BentenTmSearchResult> list = CatTmUiPlugin.getDefault().fuzzyMatch(text);
				if (monitor.isCanceled()) {
					return Status.CANCEL_STATUS;
				}
				Display.getDefault().asyncExec(new Runnable() {
					public void run() {
						viewer.setInput(list);
					}
				});
				return Status.OK_STATUS;
			}
		};
		job.setUser(true);
		job.schedule();
	}

	/**
	 * ビューの表示。
	 * @return 翻訳ビュー
	 */
	public TranslationView showView() {
		try {
			return (TranslationView) targetEditor.getSite().getPage().showView(TranslationView.class.getName());
		} catch (final PartInitException e) {
			CatTmUiPlugin.getDefault().log(e);
			throw new IllegalStateException(e);
		}
	}
}
