/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.tmx.core;

import blanco.tmx.valueobject.BlancoTmxTu;

/**
 * TMX の tu の tuv について、seg を見ながら特定のルールで比較します。
 * 
 * <UL>
 * <LI>このクラスは、オブジェクトの比較のためのみに利用することを想定しており、Comparator は実装しません。
 * <LI>前提条件: tuv の 1 つ目には en、2 つ目には ローカル言語が入っていることを前提とします。
 * </UL>
 * 
 * @author IGA Tosiki
 */
public class BentenTmxTuComparator implements java.util.Comparator<BlancoTmxTu> {
	public int compare(final BlancoTmxTu tuLeft, final BlancoTmxTu tuRight) {
		// tuv が 1 つも無い場合にはソートできません。
		if (Math.max(tuLeft.getTuvList().size(), tuRight.getTuvList().size()) == 0) {
			return 0;
		}
		// いずれか一方に tuv がある場合には、その有無によってソートします。
		if (Math.min(tuLeft.getTuvList().size(), tuRight.getTuvList().size()) == 0) {
			return tuLeft.getTuvList().size() - tuRight.getTuvList().size();
		}

		// 1 つ目の tuv の seg でソートします。
		// ※注意。lang 属性ではソートしていません。
		final int sortBySeg1 = tuLeft.getTuvList().get(0).getSeg().compareTo(tuRight.getTuvList().get(0).getSeg());
		if (sortBySeg1 != 0) {
			return sortBySeg1;
		}

		// tuv の 2 つ目が無い場合にはソートできません。
		if (Math.max(tuLeft.getTuvList().size(), tuRight.getTuvList().size()) == 1) {
			return 0;
		}
		// いずれか一方に 2 つ目の tuv がある場合には、その有無によってソートします。
		if (Math.min(tuLeft.getTuvList().size(), tuRight.getTuvList().size()) == 1) {
			return tuLeft.getTuvList().size() - tuRight.getTuvList().size();
		}

		// 2 つ目の tuv の seg でソートします。
		final int sortBySeg2 = tuLeft.getTuvList().get(1).getSeg().compareTo(tuRight.getTuvList().get(1).getSeg());
		if (sortBySeg2 != 0) {
			return sortBySeg2;
		}

		// これ以上ソートは実施しません。
		return 0;
	}
}
