/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.ui.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;

import benten.twa.ui.dialogs.AbstractWorkflowDialog;

/**
 * ワークフロー・ダイアログをウィザード・ページとして使用するための基底クラス。<br>
 * ワークフロー・ダイアログをラッピングしたウィザード・ページです。
 *
 * @author KASHIHARA Shinji
 */
public abstract class AbstractWorkflowDialogWizardPage extends WizardPage {

	/** 選択。 */
	private final IStructuredSelection fSelection;
	/** ワークフロー・ダイアログ。 */
	private AbstractWorkflowDialog fWorkflowDialog;

	/**
	 * コンストラクター。
	 * @param selection 選択
	 */
	protected AbstractWorkflowDialogWizardPage(final IStructuredSelection selection) {
		super(AbstractWorkflowDialogWizardPage.class.getName());
		fSelection = selection;
	}

	/**
	 * {@inheritDoc}
	 */
	public void createControl(final Composite parent) {
		fWorkflowDialog = createWorkflowDialog(parent, fSelection);
		fWorkflowDialog.setModifyListner(new ModifyListener() {
			public void modifyText(final ModifyEvent e) {
				final IStatus status = fWorkflowDialog.getValidateStatus();
				if (status.matches(IStatus.ERROR)) {
					setErrorMessage(status.getMessage());
					setPageComplete(false);
				} else {
					setErrorMessage(null);
					setMessage(status.getMessage());
					setPageComplete(true);
				}
			}
		});
		final Composite composite = new Composite(parent, SWT.NULL);
		fWorkflowDialog.createControls(composite);
		setControl(composite);
	}

	/**
	 * ワークフロー・ダイアログの作成。
	 * @param parent 親コンポジット
	 * @param selection 選択
	 * @return ワークフロー・ダイアログ
	 */
	abstract public AbstractWorkflowDialog createWorkflowDialog(final Composite parent,
			final IStructuredSelection selection);

	/**
	 * ワークフロー・ダイアログの取得。
	 * @return ワークフロー・ダイアログ
	 */
	public AbstractWorkflowDialog getWorkflowDialog() {
		return fWorkflowDialog;
	}
}
