/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.filter.core;

import java.io.File;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import benten.core.io.Files;
import blanco.html.parser.BlancoHtmlParser;
import blanco.html.parser.BlancoHtmlParserFactory;
import blanco.html.parser.helper.BlancoHtmlNullContentHandler;

/**
 * TWA フィルターのための HTML ユーティリティ－・クラス。
 * 
 * @author IGA Tosiki
 */
public class BentenTwaFilterHtmlUtil {

	/**
	 * 隠されたコンストラクター。
	 * 
	 * <UL>
	 * <LI>このクラスはユーティリティ・クラスです。
	 * <LI>インスタンス生成を抑制するために、コンストラクターは private で修飾されています。
	 * </UL>
	 */
	private BentenTwaFilterHtmlUtil() {
	}

	/**
	 * 与えられた HTML ファイルに HTML タグが存在するかどうかを確認。
	 * 
	 * @param file チェック対象の HTML ファイル。
	 * @return HTML タグが存在すれば true。存在しない、ファイル読み込みに失敗、ファイルのパースに失敗なら false。
	 */
	public static boolean isHtmlTagExist(final File file) {
		try {
			byte[] bytes = Files.readFileToByteArray(file);
			final boolean[] htmlTagExist = new boolean[1];
			final BlancoHtmlParser parser = BlancoHtmlParserFactory.getInstance();
			parser.setHandler(new BlancoHtmlNullContentHandler() {
				@Override
				public void startElement(final String uri, final String localName, final String name,
						final Attributes atts) throws SAXException {
					if (localName.toUpperCase().equals("HTML")) { //$NON-NLS-1$
						// HTML タグが存在します。
						htmlTagExist[0] = true;
					}
				}
			});
			parser.parse(bytes);
			return htmlTagExist[0];
		} catch (Exception e) {
			// 例外が発生した場合には、HTML タグが発見できなかったものと同じ扱いとします。
			return false;
		}
	}
}
