/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.filter.handler;

import java.io.IOException;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.SAXException;

import benten.twa.filter.core.BentenConvertToXliffBatchProcess;
import benten.twa.filter.core.BentenConvertToXliffProcessImpl;
import benten.twa.filter.core.valueobject.BentenConvertToXliffProcessInput;
import benten.twa.filter.dialogs.ConvertToXliffDialog;
import benten.twa.filter.messages.BentenConvertToXliffMessages;
import benten.twa.filter.status.BentenConvertToXliffStatus;
import benten.twa.ui.jobs.AbstractWorkflowHandler;
import benten.ui.preference.BentenProjectProperty;
import benten.ui.preference.BentenProjectProperty.ProjectProperty;

/**
 * HTML－XLIFF 変換ハンドラーです。
 *
 * 翻訳対象を XLIFF に変換
 *
 * <pre>
 * 翻訳対象物を XLIFF に変換します。
 *   1.  プロジェクト内にインポートされた翻訳対象物を、XLIFF に変換します。
 * </pre>
 * 
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳対象物－翻訳中間形式変換機能: HTML－XLIFF変換機能」に対応します。
 * 
 * @author KASHIHARA Shinji
 */
public class ConvertToXliffHandler extends AbstractWorkflowHandler {
	/**
	 * HTML－XLIFF変換機能のためのメッセージ。
	 */
	protected static final BentenConvertToXliffMessages fMsg = new BentenConvertToXliffMessages();

	@Override
	protected StatusDialog createDialog(final Shell shell, final IStructuredSelection selection) {
		setJobMessage(fMsg.getJobName());
		return new ConvertToXliffDialog(shell, selection);
	}

	@Override
	protected void processFile(final IStatus iStatus) throws IOException, SAXException {
		final BentenConvertToXliffStatus status = (BentenConvertToXliffStatus) iStatus;

		final BentenConvertToXliffProcessInput input = new BentenConvertToXliffProcessInput();
		input.setSourcedir(status.getFromDir().getAbsolutePath());
		input.setTargetdir(status.getToDir().getAbsolutePath());
		input.setTranstargetid(status.getTransTargetId());

		final IPreferenceStore projectStore = BentenProjectProperty.getStore(status.getProject());
		input
				.setTranssourcelang(projectStore.getString(BentenProjectProperty.ProjectProperty.TRANS_SOURCE_LANG
						.name()));
		input
				.setTranstargetlang(projectStore.getString(BentenProjectProperty.ProjectProperty.TRANS_TARGET_LANG
						.name()));

		new BentenConvertToXliffBatchProcess().validateInput(input);
		final BentenConvertToXliffProcessImpl process = new BentenConvertToXliffProcessImpl() {
			@Override
			protected void beginTask(final int totalWork) {
				monitor.beginTask(null, totalWork);
			}

			@Override
			public boolean progress(final String argProgressMessage) {
				monitor.subTask(argProgressMessage);
				monitor.worked(1);
				Thread.yield();
				return monitor.isCanceled();
			}
		};
		process.execute(input);
		resultInfo = process.getResultInfo();
	}

	@Override
	protected void complete(final IStatus iStatus) {
		// このプロジェクトで処理済みとマーク
		final BentenConvertToXliffStatus status = (BentenConvertToXliffStatus) iStatus;
		final IPreferenceStore projectStore = BentenProjectProperty.getStore(status.getProject());
		projectStore.setValue(ProjectProperty.XLIFF_CONVERTED.name(), true);
	}
}
