/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.filter.handler;

import java.io.IOException;

import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.SAXException;

import benten.twa.filter.core.BentenExportHtmlBatchProcess;
import benten.twa.filter.core.BentenExportHtmlProcessImpl;
import benten.twa.filter.core.valueobject.BentenExportHtmlProcessInput;
import benten.twa.filter.dialogs.ExportHtmlDialog;
import benten.twa.filter.messages.BentenExportHtmlMessages;
import benten.twa.filter.status.BentenExportHtmlStatus;
import benten.twa.ui.jobs.AbstractWorkflowHandler;

/**
 * 翻訳成果エクスポート・ハンドラーです。
 *
 * 翻訳成果のエクスポート
 * 
 * <pre>
 * 翻訳成果物をプロジェクトからエクスポートします。
 *   1.  XLIFF とインポートされた翻訳対象物をもちいて、翻訳成果物をエクスポートします。
 * </pre>
 * 
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳対象物－翻訳中間形式変換機能: HTMLエクスポート機能」に対応します。
 * 
 * @author KASHIHARA Shinji
 */
public class ExportHtmlHandler extends AbstractWorkflowHandler implements IHandler {
	/**
	 * HTMLエクスポート機能のためのメッセージ。
	 */
	protected static final BentenExportHtmlMessages fMsg = new BentenExportHtmlMessages();

	@Override
	protected StatusDialog createDialog(final Shell shell, final IStructuredSelection selection) {
		setJobMessage(fMsg.getJobName());
		return new ExportHtmlDialog(shell, selection);
	}

	@Override
	protected void processFile(final IStatus iStatus) throws IOException, SAXException {
		final BentenExportHtmlStatus status = (BentenExportHtmlStatus) iStatus;

		final BentenExportHtmlProcessInput input = new BentenExportHtmlProcessInput();
		input.setSourcexliffdir(status.getFromXliffDir().getAbsolutePath());
		input.setSourcehtmldir(status.getFromHtmlDir().getAbsolutePath());
		input.setTargetdir(status.getToDir().getAbsolutePath());

		new BentenExportHtmlBatchProcess().validateInput(input);
		final BentenExportHtmlProcessImpl process = new BentenExportHtmlProcessImpl() {
			@Override
			protected void beginTask(final int totalWork) {
				monitor.beginTask(null, totalWork);
			}

			@Override
			public boolean progress(final String argProgressMessage) {
				monitor.subTask(argProgressMessage);
				monitor.worked(1);
				Thread.yield();
				return monitor.isCanceled();
			}
		};
		process.execute(input);
		resultInfo = process.getResultInfo();
	}
}
