/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.filter.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;

import benten.twa.filter.dialogs.ImportHtmlDialog;
import benten.twa.filter.messages.BentenImportHtmlMessages;
import benten.twa.ui.dialogs.AbstractWorkflowDialog;
import benten.twa.ui.wizards.AbstractWorkflowDialogWizardPage;

/**
 * 翻訳対象のインポート。
 *
 * <pre>
 * 翻訳対象物をプロジェクトにインポートします。
 *   1.  翻訳対象物のファイルをプロジェクトにインポートします。
 *   2.  インポートされた翻訳対象物は、デフォルトではプロジェクト内の [.benten/source] ディレクトリ以下に配置されます。
 *   3.  インポートされた翻訳対象物は、エクスポートの際に利用されます。
 *   4.  インポートされた翻訳対象物は、直接編集しないでください。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳対象物－翻訳中間形式変換機能: HTMLインポート機能」に対応します。
 *
 * @author KASHIHARA Shinji
 */
public class ImportHtmlWizardPage2 extends AbstractWorkflowDialogWizardPage {

	/**
	 * HTMLインポート機能のためのメッセージ。
	 */
	protected static final BentenImportHtmlMessages fMsg = new BentenImportHtmlMessages();

	/**
	 * コンストラクター。
	 * @param selection 選択
	 */
	protected ImportHtmlWizardPage2(final IStructuredSelection selection) {
		super(selection);
		setTitle(fMsg.getWizardPage2Title());
		setDescription(fMsg.getWizardPage2Description());
	}

	@Override
	public AbstractWorkflowDialog createWorkflowDialog(final Composite parent, final IStructuredSelection selection) {
		return new ImportHtmlDialog(parent.getShell(), selection);
	}
}
