/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.stat.handler.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * 翻訳統計取得ハンドラー抽象クラスのためのメッセージ。
 *
 * リソースバンドル定義: [AbstractStatHandlerMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class AbstractStatHandlerMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * AbstractStatHandlerMessagesクラスのコンストラクタ。
     *
     * 基底名[AbstractStatHandlerMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public AbstractStatHandlerMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/stat/handler/messages/AbstractStatHandlerMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * AbstractStatHandlerMessagesクラスのコンストラクタ。
     *
     * 基底名[AbstractStatHandlerMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public AbstractStatHandlerMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/stat/handler/messages/AbstractStatHandlerMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * AbstractStatHandlerMessagesクラスのコンストラクタ。
     *
     * 基底名[AbstractStatHandlerMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public AbstractStatHandlerMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/stat/handler/messages/AbstractStatHandlerMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[AbstractStatHandlerMessages], key[Msg.001]
     *
     * [Select a file or directory to process.] (en)<br>
     * [処理対象となるファイルまたはディレクトリーを選択してください。] (ja)<br>
     *
     * @return key[Msg.001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg001() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Select a file or directory to process.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.001");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[AbstractStatHandlerMessages], key[Msg.002]
     *
     * [Please select a file to process] (en)<br>
     * [処理対象を選択してください] (ja)<br>
     *
     * @return key[Msg.002]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg002() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Please select a file to process";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.002");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[AbstractStatHandlerMessages], key[Msg.003]
     *
     * [The specified file could not be found.] (en)<br>
     * [処理対象となるファイルがありませんでした。] (ja)<br>
     *
     * @return key[Msg.003]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg003() {
        // 初期値として定義書の値を利用します。
        String strFormat = "The specified file could not be found.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.003");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[AbstractStatHandlerMessages], key[Msg.004]
     *
     * [The specified file could not be found.] (en)<br>
     * [処理対象がありません] (ja)<br>
     *
     * @return key[Msg.004]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg004() {
        // 初期値として定義書の値を利用します。
        String strFormat = "The specified file could not be found.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.004");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[AbstractStatHandlerMessages], key[Msg.005]
     *
     * [Gathering the translation statistics...] (en)<br>
     * [翻訳統計取得中...] (ja)<br>
     *
     * @return key[Msg.005]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg005() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Gathering the translation statistics...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.005");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[AbstractStatHandlerMessages], key[Msg.006]
     *
     * [ProcessFile: {0}] (en)<br>
     * [ProcessFile: {0}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[Msg.006]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg006(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "ProcessFile: {0}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.006");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[AbstractStatHandlerMessages], key[Msg.007]
     *
     * [Failed to get the glossary engine] (en)<br>
     * [用語集エンジンの取得に失敗] (ja)<br>
     *
     * @return key[Msg.007]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg007() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Failed to get the glossary engine";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.007");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
