/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.glossary.ui.editor;

import java.util.List;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;

import benten.cat.glossary.core.BentenGlossaryEngine;
import benten.cat.glossary.core.BentenGlossarySearchResult;
import benten.cat.glossary.ui.CatGlossaryUiPlugin;

/**
 * 用語集コンテンツ・アシスト・プロセッサー。
 *
 * <UL>
 * <LI>用語集のコンテンツ・アシストを可能にするクラスです。
 * <LI>処理は {@link BentenGlossaryEngine} に委譲されます。
 * </UL>
 *
 * ★基本設計「翻訳支援機能: 翻訳中間形式エディター機能: 用語対訳による補完」に対応します。
 *
 * @author YAMAMOTO Koji
 * @author KASHIHARA Shinji
 */
@SuppressWarnings("restriction")
public class GlossaryAssistProcessor implements IContentAssistProcessor {

	/**
	 * {@inheritDoc}
	 */
	public ICompletionProposal[] computeCompletionProposals(final ITextViewer viewer, final int offset) {
		final String source = viewer.getDocument().get();
		final Point selectedRangePoint = viewer.getSelectedRange();
		String target = null;
		int replacementOffset;

		if (hasSelection(selectedRangePoint)) {
			target = source.substring(selectedRangePoint.x, selectedRangePoint.x + selectedRangePoint.y);
			replacementOffset = selectedRangePoint.x + selectedRangePoint.y;
		} else {
			target = getTargetString(source, offset);
			replacementOffset = offset;
		}

		final BentenGlossaryEngine glossaryEngine = CatGlossaryUiPlugin.getDefault().getGlossaryEngine();
		final List<BentenGlossarySearchResult> glossaryEntries = glossaryEngine.search(target);

		final ICompletionProposal[] proposals = new ICompletionProposal[glossaryEntries.size()];

		for (int i = 0; i < glossaryEntries.size(); i++) {
			final BentenGlossarySearchResult glossaryEntry = glossaryEntries.get(i);
			final String srcText = glossaryEntry.getSource();
			final String replacement = glossaryEntry.getTarget();
			final String comment = glossaryEntry.getNote();
			proposals[i] = new CustomCompletionProposal(replacement, replacementOffset - target.length(), target
					.length(), replacement.length(), null, srcText + " - " + replacement, null, comment, 0, false); //$NON-NLS-1$
		}
		return proposals;
	}

	/**
	 * {@inheritDoc}
	 */
	public IContextInformation[] computeContextInformation(final ITextViewer viewer, final int offset) {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public char[] getCompletionProposalAutoActivationCharacters() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public char[] getContextInformationAutoActivationCharacters() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public IContextInformationValidator getContextInformationValidator() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public String getErrorMessage() {
		return null;
	}

	/**
	 * 選択されているか判定。
	 * @param selectedRangePoint 選択範囲ポイント
	 * @return 選択されている場合は true
	 */
	protected boolean hasSelection(final Point selectedRangePoint) {
		return selectedRangePoint.y > 0;
	}

	/**
	 * 対象となる文字列の取得。
	 * @param source ソース
	 * @param offset オフセット
	 * @return 対象となる文字列
	 */
	protected String getTargetString(final String source, final int offset) {
		final String beforeOffset = source.substring(0, offset);
		final String targetString = beforeOffset.replaceFirst(
				"(?s)(?i)([a-z-\\.]*[^a-z-\\.]*)*?([a-z-\\.]+[^a-z-\\.]*)$", //$NON-NLS-1$
				"$2"); //$NON-NLS-1$
		return targetString;
	}
}
