/*******************************************************************************
 * Copyright (c) 2010 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.ui.fields;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;

/**
 * フィールドのためのユーティリティ。
 * @author NDB伊賀
 */
public class ControlUtil {
	/**
	 * コントロールを修飾する情報テキストを設定します。
	 * @param control セットするコントロール。
	 * @param strTooltip セットする文字列。
	 */
	public static void setInfoDecoration(final Control control, final String strTooltip) {
		final ControlDecoration decoration = new ControlDecoration(control, SWT.RIGHT | SWT.BOTTOM);
		decoration.setDescriptionText(strTooltip);
		final FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration(
				FieldDecorationRegistry.DEC_INFORMATION);
		decoration.setImage(fieldDecoration.getImage());
		decoration.show();
	}
}
