/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.ui.views;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * 基本的なウィジェットを生成する UI ツールキット。
 *
 * @author KASHIHARA Shinji
 */
public class UiToolkit {

	/**
	 * コンストラクター。
	 */
	public UiToolkit() {
	}

	/**
	 * コンテナーに合わせて水平方向に広がるスペーサーを生成。
	 * @param parent 親コンポジット
	 * @return スペーサー
	 */
	public Control createHorizontalSpacer(final Composite parent) {
		final Control spacer = new Text(parent, SWT.NULL);
		spacer.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		spacer.setEnabled(false);
		return spacer;
	}

	/**
	 * コンポジットを生成。
	 * @param parent 親コンポジット
	 * @param numColumns  グリッド・レイアウト列数
	 * @return コンポジット
	 */
	public Composite createComposite(final Composite parent, final int numColumns) {
		return createComposite(parent, numColumns, 0);
	}

	/**
	 * コンポジットを生成。
	 * @param parent 親コンポジット
	 * @param numColumns  グリッド・レイアウト列数
	 * @param margin グリッド・レイアウト・マージン
	 * @return コンポジット
	 */
	public Composite createComposite(final Composite parent, final int numColumns, final int margin) {
		final Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(createGridLayout(numColumns, margin));
		return composite;
	}

	/**
	 * グリッド・レイアウトを生成。
	 * @param numColumns 列数
	 * @param margin マージン
	 * @return グリッド・レイアウト
	 */
	public GridLayout createGridLayout(final int numColumns, final int margin) {
		final GridLayout gl = new GridLayout(numColumns, false);
		gl.marginWidth = margin;
		gl.marginHeight = margin;
		return gl;
	}

	/**
	 * ラベルを生成。
	 * @param parent 親コンポジット
	 * @param text テキスト
	 * @return ラベル
	 */
	public Label createLabel(final Composite parent, final String text) {
		final Label label = new Label(parent, SWT.NULL);
		label.setText(text);
		return label;
	}

	/**
	 * ラベルを生成。
	 * @param parent 親コンポジット
	 * @param text テキスト
	 * @param widthHint 横幅ヒント
	 * @return ラベル
	 */
	public Label createLabel(final Composite parent, final String text, final int widthHint) {
		final GridData gd = new GridData();
		gd.widthHint = widthHint;
		final Label label = createLabel(parent, text);
		label.setLayoutData(gd);
		return label;
	}

	/**
	 * ボタンを生成。
	 * @param parent 親コンポジット
	 * @param text テキスト
	 * @param widthHint 横幅ヒント
	 * @return ボタン
	 */
	public Button createButton(final Composite parent, final String text, final int widthHint) {
		final GridData gd = new GridData();
		gd.widthHint = widthHint;
		final Button b = new Button(parent, SWT.PUSH);
		b.setText(text);
		b.setLayoutData(gd);
		return b;
	}
}
