/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.cat.messages;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * 翻訳対象外マーク機能のためのメッセージ。
 *
 * リソースバンドル定義: [BentenMarkNoTransableMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class BentenMarkNoTransableMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * BentenMarkNoTransableMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenMarkNoTransableMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public BentenMarkNoTransableMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/cat/messages/BentenMarkNoTransableMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenMarkNoTransableMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenMarkNoTransableMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public BentenMarkNoTransableMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/cat/messages/BentenMarkNoTransableMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenMarkNoTransableMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenMarkNoTransableMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public BentenMarkNoTransableMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/cat/messages/BentenMarkNoTransableMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BentenMarkNoTransableMessages], key[WindowTitle]
     *
     * [Mark as Non-Translatable] (en)<br>
     * [翻訳対象外のマーク] (ja)<br>
     *
     * @return key[WindowTitle]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWindowTitle() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Mark as Non-Translatable";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WindowTitle");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenMarkNoTransableMessages], key[JobName]
     *
     * [Marking as Non-Translatable...] (en)<br>
     * [翻訳対象外のマーク中...] (ja)<br>
     *
     * @return key[JobName]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getJobName() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Marking as Non-Translatable...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("JobName");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenMarkNoTransableMessages], key[WizardPageTitle]
     *
     * [Welcome] (en)<br>
     * [ようこそ] (ja)<br>
     *
     * @return key[WizardPageTitle]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPageTitle() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Welcome";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPageTitle");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenMarkNoTransableMessages], key[WizardPageDescription]
     *
     * [Mark the translation unit that doesn't need to translate in XLIFF as non-translatable.] (en)<br>
     * [XLIFF 内の翻訳の必要のない翻訳単位を、翻訳対象外としてマークします。] (ja)<br>
     *
     * @return key[WizardPageDescription]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPageDescription() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Mark the translation unit that doesn't need to translate in XLIFF as non-translatable.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPageDescription");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenMarkNoTransableMessages], key[WizardPageLabel1]
     *
     * [This wizard marks the translation unit that doesn't need to translate in XLIFF as non-translatable.\n\n 1.  Determine the need for translation from the contents of the XLIFF translation unit.\n 2.  Mark the translation unit that was determined not to be translated as non-translatable.] (en)<br>
     * [このウィザードは、XLIFF 内の翻訳の必要のない翻訳単位を、翻訳対象外としてマークします。\n\n 1.  XLIFF の翻訳単位の内容から、翻訳の必要の有無を判断します。\n 2.  翻訳の必要がないと判断されたものについて、翻訳対象外としてマークします。] (ja)<br>
     *
     * @return key[WizardPageLabel1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPageLabel1() {
        // 初期値として定義書の値を利用します。
        String strFormat = "This wizard marks the translation unit that doesn't need to translate in XLIFF as non-translatable.\n\n 1.  Determine the need for translation from the contents of the XLIFF translation unit.\n 2.  Mark the translation unit that was determined not to be translated as non-translatable.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPageLabel1");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenMarkNoTransableMessages], key[WizardPage2Title]
     *
     * [Target Directory] (en)<br>
     * [対象ディレクトリーの指定] (ja)<br>
     *
     * @return key[WizardPage2Title]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPage2Title() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Target Directory";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPage2Title");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenMarkNoTransableMessages], key[WizardPage2Description]
     *
     * [Specify the target directory.] (en)<br>
     * [対象ディレクトリーを指定します] (ja)<br>
     *
     * @return key[WizardPage2Description]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPage2Description() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Specify the target directory.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPage2Description");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenMarkNoTransableMessages], key[WizardPage3ResultMessage]
     *
     * [Mark as non-translatable completed.] (en)<br>
     * [翻訳対象外のマークが完了しました。] (ja)<br>
     *
     * @return key[WizardPage3ResultMessage]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPage3ResultMessage() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Mark as non-translatable completed.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPage3ResultMessage");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenMarkNoTransableMessages], key[DialogCtrlLabelTargetXliffDir]
     *
     * [Target XLIFF directory] (en)<br>
     * [対象 XLIFF ディレクトリー] (ja)<br>
     *
     * @return key[DialogCtrlLabelTargetXliffDir]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlLabelTargetXliffDir() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Target XLIFF directory";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlLabelTargetXliffDir");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenMarkNoTransableMessages], key[CoreP001]
     *
     * [Planning the process items...] (en)<br>
     * [処理内容を計画中...] (ja)<br>
     *
     * @return key[CoreP001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP001() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Planning the process items...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP001");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenMarkNoTransableMessages], key[CoreP002]
     *
     * [Processing the directory listings...] (en)<br>
     * [ディレクトリー一覧処理を実行中...] (ja)<br>
     *
     * @return key[CoreP002]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP002() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Processing the directory listings...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP002");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenMarkNoTransableMessages], key[CoreP003]
     *
     * [Process completed.\n{0}] (en)<br>
     * [処理を完了しました。\n{0}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreP003]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP003(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Process completed.\n{0}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP003");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenMarkNoTransableMessages], key[CoreP011]
     *
     * [Processing the XLIFF file [{0}]...] (en)<br>
     * [XLIFF ファイル [{0}] を処理中...] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreP011]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP011(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Processing the XLIFF file [{0}]...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP011");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenMarkNoTransableMessages], key[CoreP013]
     *
     * [XLIFF file [{0}] processed.] (en)<br>
     * [XLIFF ファイル [{0}] を処理しました。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreP013]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP013(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "XLIFF file [{0}] processed.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP013");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenMarkNoTransableMessages], key[CoreP101]
     *
     * [Processing the file [{0}] ({1,number}/{2,number})...] (en)<br>
     * [ファイル [{0}] ({1,number}/{2,number}) を処理中...] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @param arg1 置換文字列{1}を置換する値。java.math.BigDecimal型を与えてください。
     * @param arg2 置換文字列{2}を置換する値。java.math.BigDecimal型を与えてください。
     * @return key[CoreP101]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP101(final String arg0, final BigDecimal arg1, final BigDecimal arg2) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Processing the file [{0}] ({1,number}/{2,number})...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP101");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0, arg1, arg2}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenMarkNoTransableMessages], key[CoreE004]
     *
     * [XLIFF directory [{0}] could not be found.] (en)<br>
     * [XLIFF ディレクトリー [{0}] は見つかりませんでした。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE004]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE004(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "XLIFF directory [{0}] could not be found.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE004");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenMarkNoTransableMessages], key[CoreE005]
     *
     * [XLIFF directory [{0}] is actually not a directory.] (en)<br>
     * [XLIFF ディレクトリー [{0}] は、実際にはディレクトリーではありませんでした。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE005]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE005(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "XLIFF directory [{0}] is actually not a directory.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE005");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenMarkNoTransableMessages], key[CoreE011]
     *
     * [Exception occurred while reading the XLIFF file [{0}]: {1}] (en)<br>
     * [XLIFF ファイル [{0}] の読み込み時に例外が発生しました。: {1}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @param arg1 置換文字列{1}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE011]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE011(final String arg0, final String arg1) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Exception occurred while reading the XLIFF file [{0}]: {1}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE011");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenMarkNoTransableMessages], key[CoreE012]
     *
     * [Exception occurred while writing the XLIFF file [{0}]: {1}] (en)<br>
     * [XLIFF ファイル [{0}] の書き込み時に例外が発生しました。: {1}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @param arg1 置換文字列{1}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE012]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE012(final String arg0, final String arg1) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Exception occurred while writing the XLIFF file [{0}]: {1}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE012");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }
}
