/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.cat.wizards;

import benten.twa.cat.handler.ApplyFuzzyMatchHandler;
import benten.twa.cat.messages.BentenApplyFuzzyMatchMessages;
import benten.twa.ui.jobs.WorkflowJob;
import benten.twa.ui.wizards.AbstractWorkflowWizard;

/**
 * 類似訳の適用
 *
 * <pre>
 * このウィザードは、TMX の類似訳を XLIFF に適用します。
 *   1.  翻訳単位と類似する TMX を探し、翻訳単位の代替翻訳に適用します。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳中間形式機械支援翻訳機能: 類似訳適用機能」に対応します。
 * 
 * @author YAMAMOTO Koji
 */
public class ApplyFuzzyMatchWizard extends AbstractWorkflowWizard {
	/**
	 * 類似訳適用機能のためのメッセージ。
	 */
	protected static final BentenApplyFuzzyMatchMessages fMsg = new BentenApplyFuzzyMatchMessages();

	@Override
	public void addPages() {
		setWindowTitle(fMsg.getWindowTitle());
		addPage(new ApplyFuzzyMatchWizardPage());
		addPage(new ApplyFuzzyMatchWizardPage2(getSelection()));
	}

	@Override
	protected void scheduleJob() {
		final WorkflowJob job = new WorkflowJob(fMsg.getJobName());
		job.setStatus(getStatus());
		job.setHandler(new ApplyFuzzyMatchHandler());
		job.setCompleteMessage(getWindowTitle(), fMsg.getWizardPage3ResultMessage());
		job.schedule();
	}
}
