/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.ui.wizards.messages;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * 翻訳プロジェクト作成ウィザードのためのメッセージ。
 *
 * リソースバンドル定義: [NewProjectCreationWizardMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class NewProjectCreationWizardMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * NewProjectCreationWizardMessagesクラスのコンストラクタ。
     *
     * 基底名[NewProjectCreationWizardMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public NewProjectCreationWizardMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/ui/wizards/messages/NewProjectCreationWizardMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * NewProjectCreationWizardMessagesクラスのコンストラクタ。
     *
     * 基底名[NewProjectCreationWizardMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public NewProjectCreationWizardMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/ui/wizards/messages/NewProjectCreationWizardMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * NewProjectCreationWizardMessagesクラスのコンストラクタ。
     *
     * 基底名[NewProjectCreationWizardMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public NewProjectCreationWizardMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/ui/wizards/messages/NewProjectCreationWizardMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[NewProjectCreationWizardMessages], key[WindowTitle]
     *
     * [Create Translation Project] (en)<br>
     * [翻訳プロジェクトの作成] (ja)<br>
     *
     * @return key[WindowTitle]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWindowTitle() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Create Translation Project";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WindowTitle");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[NewProjectCreationWizardMessages], key[WizardPageTitle]
     *
     * [Create Translation Project] (en)<br>
     * [翻訳プロジェクトの作成] (ja)<br>
     *
     * @return key[WizardPageTitle]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPageTitle() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Create Translation Project";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPageTitle");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[NewProjectCreationWizardMessages], key[WizardPageDescription]
     *
     * [Create new translation project. Create new translation project for each translation target and use it.] (en)<br>
     * [翻訳プロジェクトを新規作成します。翻訳対象ごとに、翻訳プロジェクトを 1 つ作成して利用してください。] (ja)<br>
     *
     * @return key[WizardPageDescription]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPageDescription() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Create new translation project. Create new translation project for each translation target and use it.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPageDescription");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[NewProjectCreationWizardMessages], key[Label.GroupTransLang]
     *
     * [Translation Language Settings] (en)<br>
     * [翻訳言語の設定] (ja)<br>
     *
     * @return key[Label.GroupTransLang]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelGroupTransLang() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Translation Language Settings";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.GroupTransLang");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[NewProjectCreationWizardMessages], key[Label.SourceLang]
     *
     * [Translation Source Language:] (en)<br>
     * [翻訳元の言語:] (ja)<br>
     *
     * @return key[Label.SourceLang]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelSourceLang() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Translation Source Language:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.SourceLang");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[NewProjectCreationWizardMessages], key[Label.TargetLang]
     *
     * [Translation Target Language:] (en)<br>
     * [翻訳先の言語:] (ja)<br>
     *
     * @return key[Label.TargetLang]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelTargetLang() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Translation Target Language:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.TargetLang");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[NewProjectCreationWizardMessages], key[Button.Reverse]
     *
     * [Reverse translation language] (en)<br>
     * [翻訳言語の反転] (ja)<br>
     *
     * @return key[Button.Reverse]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getButtonReverse() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Reverse translation language";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Button.Reverse");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[NewProjectCreationWizardMessages], key[DefaultTransSourceLang]
     *
     * [en-US] (en)<br>
     * [en-US] (ja)<br>
     *
     * @return key[DefaultTransSourceLang]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDefaultTransSourceLang() {
        // 初期値として定義書の値を利用します。
        String strFormat = "en-US";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DefaultTransSourceLang");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[NewProjectCreationWizardMessages], key[DefaultTransTargetLang]
     *
     * [ja-JP] (en)<br>
     * [ja-JP] (ja)<br>
     *
     * @return key[DefaultTransTargetLang]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDefaultTransTargetLang() {
        // 初期値として定義書の値を利用します。
        String strFormat = "ja-JP";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DefaultTransTargetLang");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[NewProjectCreationWizardMessages], key[Dlg.Error.0]
     *
     * [Please set different value between translation source language and translation target language.] (en)<br>
     * [翻訳元の言語と翻訳先の言語は異なるようにしてください。] (ja)<br>
     *
     * @return key[Dlg.Error.0]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDlgError0() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Please set different value between translation source language and translation target language.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Dlg.Error.0");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
