/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.tm.data.tmx;

import org.osgi.framework.BundleContext;

import benten.cat.tm.data.AbstractBentenTmDataTmxPlugin;

/**
 * CAT TM エンジン・データ TMX プラグイン。
 * 
 * <UL>
 * <LI>このプラグインを Eclipse 上で有効化するためのプラグイン・クラスです。
 * </UL>
 * 
 * @author YAMAMOTO Koji
 */
public class CatTmEngineDataTmxPlugin extends AbstractBentenTmDataTmxPlugin {
	/** 共用インスタンス。 */
	private static CatTmEngineDataTmxPlugin plugin;

	@Override
	public void start(final BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	@Override
	public void stop(final BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	@Override
	public AbstractBentenTmDataTmxPlugin getPluginDefault() {
		return plugin;
	}
}
