/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.tmx.messages;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * TMXフラグメント抽出機能のためのメッセージ。
 *
 * リソースバンドル定義: [BentenExtractTmxFragmentMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class BentenExtractTmxFragmentMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * BentenExtractTmxFragmentMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenExtractTmxFragmentMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public BentenExtractTmxFragmentMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/tmx/messages/BentenExtractTmxFragmentMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenExtractTmxFragmentMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenExtractTmxFragmentMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public BentenExtractTmxFragmentMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/tmx/messages/BentenExtractTmxFragmentMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenExtractTmxFragmentMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenExtractTmxFragmentMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public BentenExtractTmxFragmentMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/tmx/messages/BentenExtractTmxFragmentMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[WindowTitle]
     *
     * [Extract TMX Fragments] (en)<br>
     * [TMX フラグメントの抽出] (ja)<br>
     *
     * @return key[WindowTitle]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWindowTitle() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Extract TMX Fragments";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WindowTitle");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[JobName]
     *
     * [Extracting the TMX fragments...] (en)<br>
     * [TMX フラグメントの抽出中...] (ja)<br>
     *
     * @return key[JobName]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getJobName() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Extracting the TMX fragments...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("JobName");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[WizardPageTitle]
     *
     * [Welcome] (en)<br>
     * [ようこそ] (ja)<br>
     *
     * @return key[WizardPageTitle]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPageTitle() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Welcome";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPageTitle");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[WizardPageDescription]
     *
     * [Extract the TMX fragments from the XLIFF fragments.] (en)<br>
     * [XLIFF フラグメントから TMX フラグメントを抽出します。] (ja)<br>
     *
     * @return key[WizardPageDescription]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPageDescription() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Extract the TMX fragments from the XLIFF fragments.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPageDescription");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[WizardPageLabel1]
     *
     * [This wizard extracts the TMX fragments from the XLIFF fragments.\n\n 1.  Create TMX by extracting the translation units from XLIFF.] (en)<br>
     * [このウィザードは、XLIFF フラグメントから、TMX フラグメントを抽出します。\n\n 1.  XLIFF から翻訳単位を抽出して TMX を作成します。] (ja)<br>
     *
     * @return key[WizardPageLabel1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPageLabel1() {
        // 初期値として定義書の値を利用します。
        String strFormat = "This wizard extracts the TMX fragments from the XLIFF fragments.\n\n 1.  Create TMX by extracting the translation units from XLIFF.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPageLabel1");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[WizardPage2Title]
     *
     * [Target Directory] (en)<br>
     * [対象ディレクトリーの指定] (ja)<br>
     *
     * @return key[WizardPage2Title]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPage2Title() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Target Directory";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPage2Title");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[WizardPage2Description]
     *
     * [Specify the target directory.] (en)<br>
     * [対象ディレクトリーを指定します。] (ja)<br>
     *
     * @return key[WizardPage2Description]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPage2Description() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Specify the target directory.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPage2Description");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[WizardPage3ResultMessage]
     *
     * [Extraction of the TMX fragments completed.] (en)<br>
     * [TMX フラグメントの抽出が完了しました。] (ja)<br>
     *
     * @return key[WizardPage3ResultMessage]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPage3ResultMessage() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Extraction of the TMX fragments completed.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPage3ResultMessage");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[DialogCtrlLabelFromXliffDir]
     *
     * [XLIFF Directory] (en)<br>
     * [XLIFF ディレクトリー] (ja)<br>
     *
     * @return key[DialogCtrlLabelFromXliffDir]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlLabelFromXliffDir() {
        // 初期値として定義書の値を利用します。
        String strFormat = "XLIFF Directory";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlLabelFromXliffDir");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[DialogCtrlLabelToTmxDir]
     *
     * [TMX Directory] (en)<br>
     * [TMX ディレクトリー] (ja)<br>
     *
     * @return key[DialogCtrlLabelToTmxDir]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlLabelToTmxDir() {
        // 初期値として定義書の値を利用します。
        String strFormat = "TMX Directory";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlLabelToTmxDir");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[DialogCtrlGroupExtractMethod]
     *
     * [Extraction Method] (en)<br>
     * [抽出方法] (ja)<br>
     *
     * @return key[DialogCtrlGroupExtractMethod]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlGroupExtractMethod() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Extraction Method";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlGroupExtractMethod");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[DialogCtrlButtonStateCheck]
     *
     * [Extract by State] (en)<br>
     * [状態で抽出] (ja)<br>
     *
     * @return key[DialogCtrlButtonStateCheck]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlButtonStateCheck() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Extract by State";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlButtonStateCheck");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[DialogCtrlGroupFilename]
     *
     * [Output Filename Option] (en)<br>
     * [出力ファイル名オプション] (ja)<br>
     *
     * @return key[DialogCtrlGroupFilename]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlGroupFilename() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Output Filename Option";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlGroupFilename");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[DialogCtrlButtonIncludeDateCheck]
     *
     * [Include the date in the filename] (en)<br>
     * [ファイル名に年月日を含める] (ja)<br>
     *
     * @return key[DialogCtrlButtonIncludeDateCheck]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlButtonIncludeDateCheck() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Include the date in the filename";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlButtonIncludeDateCheck");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[CoreP001]
     *
     * [Planning the process items...] (en)<br>
     * [処理内容を計画中...] (ja)<br>
     *
     * @return key[CoreP001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP001() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Planning the process items...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP001");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[CoreP002]
     *
     * [Processing the directory listings...] (en)<br>
     * [ディレクトリー一覧処理を実行中...] (ja)<br>
     *
     * @return key[CoreP002]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP002() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Processing the directory listings...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP002");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[CoreP003]
     *
     * [Sorting TMX...] (en)<br>
     * [TMX をソート中...] (ja)<br>
     *
     * @return key[CoreP003]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP003() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Sorting TMX...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP003");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[CoreP004]
     *
     * [Creating the TMX file {0}...] (en)<br>
     * [TMX ファイル [{0}] を作成中...] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreP004]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP004(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Creating the TMX file {0}...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP004");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[CoreP005]
     *
     * [Process completed.\n{0}] (en)<br>
     * [処理を完了しました。\n{0}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreP005]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP005(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Process completed.\n{0}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP005");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[CoreP011]
     *
     * [Processing the file [{0}]...] (en)<br>
     * [ファイル [{0}] を処理中...] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreP011]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP011(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Processing the file [{0}]...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP011");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[CoreP101]
     *
     * [Processing the file [{0}] ({1,number}/{2,number})...] (en)<br>
     * [ファイル [{0}] ({1,number}/{2,number}) を処理中...] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @param arg1 置換文字列{1}を置換する値。java.math.BigDecimal型を与えてください。
     * @param arg2 置換文字列{2}を置換する値。java.math.BigDecimal型を与えてください。
     * @return key[CoreP101]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP101(final String arg0, final BigDecimal arg1, final BigDecimal arg2) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Processing the file [{0}] ({1,number}/{2,number})...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP101");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0, arg1, arg2}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[CoreE011]
     *
     * [Exception occurred while reading the XLIFF file [{0}].: {1}] (en)<br>
     * [XLIFF ファイル [{0}] の読み込み時に例外が発生しました。: {1}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @param arg1 置換文字列{1}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE011]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE011(final String arg0, final String arg1) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Exception occurred while reading the XLIFF file [{0}].: {1}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE011");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[CoreE012]
     *
     * [Exception occurred while writing the TMX file [{0}].: {1}] (en)<br>
     * [TMX ファイル [{0}] の書き込み時に例外が発生しました。: {1}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @param arg1 置換文字列{1}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE012]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE012(final String arg0, final String arg1) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Exception occurred while writing the TMX file [{0}].: {1}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE012");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[CoreE013]
     *
     * [Input XLIFF directory [{0}] could not be found.] (en)<br>
     * [入力 XLIFF ディレクトリー [{0}] は見つかりませんでした。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE013]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE013(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Input XLIFF directory [{0}] could not be found.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE013");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[CoreE014]
     *
     * [Input XLIFF directory [{0}] is actually not a directory.] (en)<br>
     * [入力 XLIFF ディレクトリー [{0}] は、実際にはディレクトリーではありませんでした。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE014]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE014(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Input XLIFF directory [{0}] is actually not a directory.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE014");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[CoreE015]
     *
     * [Failed to create the specified output TMX directory &quot;{0}&quot; while trying to do since it didn't exist.] (en)<br>
     * [指定された出力先 TMX ディレクトリー ''{0}'' が存在しないので作成しようとしましたが失敗しました。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE015]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE015(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Failed to create the specified output TMX directory \"{0}\" while trying to do since it didn't exist.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE015");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExtractTmxFragmentMessages], key[CoreE016]
     *
     * [The specified output TMX directory &quot;{0}&quot; exists, but it is actually not a directory.] (en)<br>
     * [指定された出力先 TMX ディレクトリー ''{0}'' は存在しますが、実際にはディレクトリーではありません。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE016]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE016(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "The specified output TMX directory \"{0}\" exists, but it is actually not a directory.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE016");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }
}
