/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.tmx.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

import benten.core.BentenConstants;
import benten.twa.BentenTwaConstants;
import benten.twa.tmx.messages.BentenMergeTmxMessages;
import benten.twa.tmx.status.BentenMergeTmxStatus;
import benten.twa.ui.dialogs.AbstractWorkflowDialog;
import benten.ui.UiStatus;
import benten.ui.UiStatusException;
import benten.ui.fields.ResourceFileTextField;

/**
 * TMX フラグメントのマージ
 *
 * <pre>
 * TMX フラグメントを TMX にマージします。
 *   1.  TMX の内容を、別の TMX にマージします。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳メモリー断片抽出・マージ機能: TMXフラグメント・マージ機能」に対応します。
 *
 * @author IGA Tosiki
 */
public class MergeTmxDialog extends AbstractWorkflowDialog {

	/**
	 * TMXマージ機能のためのメッセージ。
	 */
	protected static final BentenMergeTmxMessages fMsg = new BentenMergeTmxMessages();

	/** コントロール・コンテナー */
	private final MergeTmxControls controls = new MergeTmxControls();

	/** コントロール・コンテナー・クラス */
	public static class MergeTmxControls {

		/** ターゲット・ファイル・テキスト */
		public ResourceFileTextField targetFileText;

		/** 出力ファイル・テキスト */
		public ResourceFileTextField toFileText;
	}

	/**
	 * コンストラクター。
	 * @param parentShell 親シェル
	 * @param selection 選択
	 */
	public MergeTmxDialog(final Shell parentShell, final IStructuredSelection selection) {
		super(parentShell, selection, fMsg.getWindowTitle());
	}

	@Override
	public void createControls(final Composite composite) {
		composite.setLayout(new GridLayout(3, false));

		controls.targetFileText = new ResourceFileTextField(composite, fMsg.getDialogCtrlLabelFromFile(),
				BentenConstants.FILE_EXT_TMX);
		controls.targetFileText.addModifyListener(this);
		if (getSelectionResource() != null) {
			controls.targetFileText.setText(getSelectionResource().getProject().getName() + "/" //$NON-NLS-1$
					+ BentenTwaConstants.DEFAULT_TMX_FRAGMENT_DIR + "/"); //$NON-NLS-1$
		}

		controls.toFileText = new ResourceFileTextField(composite, fMsg.getDialogCtrlLabelToFile(),
				BentenConstants.FILE_EXT_TMX);
		controls.toFileText.addModifyListener(this);
		if (getSelectionResource() != null) {
			controls.toFileText.setText(getSelectionResource().getProject().getName() + "/" //$NON-NLS-1$
					+ BentenTwaConstants.DEFAULT_TMX_DIR + "/"); //$NON-NLS-1$
		}
	}

	@Override
	public IStatus getResultStatus() {
		final BentenMergeTmxStatus status = new BentenMergeTmxStatus();
		status.setTargetFile(controls.targetFileText.getFile());
		status.setToFile(controls.toFileText.getFile());
		status.setProject(controls.targetFileText.getResource());
		return status;
	}

	@Override
	public IStatus validate() throws UiStatusException {
		validatePath(controls.targetFileText);
		validatePath(controls.toFileText);
		validateFromTo(controls.targetFileText, controls.toFileText);
		return UiStatus.OK_STATUS;
	}
}
