/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.glossary.ui.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * Benten 用語集 UI プラグインのためのメッセージ。
 *
 * リソースバンドル定義: [CatGlossaryUiPluginMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class CatGlossaryUiPluginMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * CatGlossaryUiPluginMessagesクラスのコンストラクタ。
     *
     * 基底名[CatGlossaryUiPluginMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public CatGlossaryUiPluginMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/glossary/ui/messages/CatGlossaryUiPluginMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * CatGlossaryUiPluginMessagesクラスのコンストラクタ。
     *
     * 基底名[CatGlossaryUiPluginMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public CatGlossaryUiPluginMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/glossary/ui/messages/CatGlossaryUiPluginMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * CatGlossaryUiPluginMessagesクラスのコンストラクタ。
     *
     * 基底名[CatGlossaryUiPluginMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public CatGlossaryUiPluginMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/glossary/ui/messages/CatGlossaryUiPluginMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[CatGlossaryUiPluginMessages], key[Msg.001]
     *
     * [{0}\nFailed to load the glossary data.\nConfirm the setting by selecting Translation &gt; Glossary Preference &gt; TSV Location.] (en)<br>
     * [{0}\n用語集データのロードに失敗しました\n翻訳 &gt; 用語集設定 &gt; 使用する TSV ロケーション を確認してください。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[Msg.001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg001(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "{0}\nFailed to load the glossary data.\nConfirm the setting by selecting Translation > Glossary Preference > TSV Location.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.001");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[CatGlossaryUiPluginMessages], key[Msg.002]
     *
     * [{0}\nFailed to load the specified glossary engine.\nConfirm the setting by selecting Translation &gt; Glossary Preference &gt; Glossary Engine.\nPlease modify the preferences of glossary engine or confirm that the necessary plug-ins are properly installed.] (en)<br>
     * [{0}\n指定された用語集エンジンのロードに失敗しました。\n翻訳 &gt; 用語集設定 &gt; 用語集エンジン を確認してください。\n利用する用語集エンジンの設定を変更するか、あるいは必要なプラグインが適切に導入されていることを確認してください。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[Msg.002]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg002(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "{0}\nFailed to load the specified glossary engine.\nConfirm the setting by selecting Translation > Glossary Preference > Glossary Engine.\nPlease modify the preferences of glossary engine or confirm that the necessary plug-ins are properly installed.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.002");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[CatGlossaryUiPluginMessages], key[getGlossaryEnginePlugin_E001]
     *
     * [It was unable to get the extension point (benten.cat.glossary.engine).] (en)<br>
     * [拡張ポイント(benten.cat.glossary.engine) を取得することができませんでした。] (ja)<br>
     *
     * @return key[getGlossaryEnginePlugin_E001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getGetGlossaryEnginePluginE001() {
        // 初期値として定義書の値を利用します。
        String strFormat = "It was unable to get the extension point (benten.cat.glossary.engine).";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("getGlossaryEnginePlugin_E001");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatGlossaryUiPluginMessages], key[getGlossaryEnginePlugin_E002]
     *
     * [It was unable to get the glossary engine plug-in from the extension point.] (en)<br>
     * [拡張ポイントから用語集エンジン・プラグインを取得することができませんでした。] (ja)<br>
     *
     * @return key[getGlossaryEnginePlugin_E002]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getGetGlossaryEnginePluginE002() {
        // 初期値として定義書の値を利用します。
        String strFormat = "It was unable to get the glossary engine plug-in from the extension point.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("getGlossaryEnginePlugin_E002");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
