/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.stat.handler;

import java.io.File;
import java.io.IOException;
import java.util.List;

import org.xml.sax.SAXException;

import benten.cat.stat.model.WordCountModel;
import benten.core.model.BentenXliff;
import benten.core.text.Strings;
import blanco.xliff.valueobject.BlancoXliffTransUnit;

/**
 * ワード数取得ハンドラー。
 * <p>
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳統計取得機能: ワード数ビュー」に対応します。
 *
 * @author KASHIHARA Shinji
 */
public class ShowWordCountHandler extends AbstractStatHandler<WordCountModel> {

	@Override
	protected WordCountModel processFile(final File file) throws IOException, SAXException {
		final BentenXliff xliff = BentenXliff.loadInstance(file);
		final List<BlancoXliffTransUnit> unitList = xliff.getAllTransUnitList();
		final WordCountModel model = new WordCountModel();
		model.setFile(file);

		setModel(unitList, model);

		return model;
	}

	/**
	 * モデルの値をセット。
	 * @param unitList 翻訳単位リスト
	 * @param model モデル
	 */
	protected void setModel(final List<BlancoXliffTransUnit> unitList, final WordCountModel model) {
		for (final BlancoXliffTransUnit unit : unitList) {
			final String source = unit.getSource();
			if (source != null && !source.trim().equals("")) { //$NON-NLS-1$
				model.setWordCount(model.getWordCount() + Strings.splitByWhitespace(source).length);
			}
		}
	}
}
