/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.ui;

import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

import benten.cat.ui.internal.tabletree.XLIFFMultiPageEditorPart;
import benten.ui.UiPlugin;

/**
 * 翻訳パースペクティブのファクトリー。
 *
 * @author KASHIHARA Shinji
 */
public class TranslationPerspectiveFactory implements IPerspectiveFactory {

	/**
	 * プロジェクト・エクスプローラーの id。
	 */
	public static final String ID_PROJECT_EXPLORER = "org.eclipse.ui.navigator.ProjectExplorer"; //$NON-NLS-1$

	/**
	 * Benten 翻訳単位リスト・ビューの id。
	 */
	public static final String ID_TRANS_UNIT_LIST = "benten.cat.ui.viewers.TransUnitListView"; //$NON-NLS-1$

	/**
	 * Benten 翻訳ビューの id。
	 */
	public static final String ID_TRANSLATION = "benten.cat.tm.ui.views.TranslationView"; //$NON-NLS-1$

	/**
	 * Benten 用語集ビューの id。
	 */
	public static final String ID_GLOSSARY = "benten.cat.glossary.ui.views.GlossaryView"; //$NON-NLS-1$

	/**
	 * {@inheritDoc}
	 */
	public void createInitialLayout(final IPageLayout layout) {
		defineLayout(layout);
	}

	/**
	 * レイアウトの定義。
	 * @param layout レイアウト
	 */
	private void defineLayout(final IPageLayout layout) {

		final String editorArea = layout.getEditorArea();

		final IFolderLayout navi = layout.createFolder("navi", IPageLayout.TOP, (float) 0.31, editorArea); //$NON-NLS-1$
		navi.addView(ID_PROJECT_EXPLORER);
		navi.addView(ID_TRANS_UNIT_LIST);
		navi.addView(IPageLayout.ID_OUTLINE);
		navi.addView(IPageLayout.ID_PROBLEM_VIEW);

		final IFolderLayout tm = layout.createFolder("tm", IPageLayout.BOTTOM, (float) 0.73, editorArea); //$NON-NLS-1$
		tm.addView(ID_TRANSLATION);
		tm.addView(ID_GLOSSARY);

		final IEditorPart editor = UiPlugin.getActivePage().getActiveEditor();
		if (editor != null && editor instanceof XLIFFMultiPageEditorPart) {
			((XLIFFMultiPageEditorPart) editor).showDesignPage();
		}
	}
}
