/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.io.messages;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * 翻訳ワークフロー処理ユーティリティのためのメッセージ。
 *
 * リソースバンドル定義: [BentenTwaProcessUtilMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class BentenTwaProcessUtilMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * BentenTwaProcessUtilMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenTwaProcessUtilMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public BentenTwaProcessUtilMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/io/messages/BentenTwaProcessUtilMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenTwaProcessUtilMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenTwaProcessUtilMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public BentenTwaProcessUtilMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/io/messages/BentenTwaProcessUtilMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenTwaProcessUtilMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenTwaProcessUtilMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public BentenTwaProcessUtilMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/io/messages/BentenTwaProcessUtilMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BentenTwaProcessUtilMessages], key[Msg.Success]
     *
     * [Normal: {0,number} units] (en)<br>
     * [正常: {0,number} 件] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.math.BigDecimal型を与えてください。
     * @return key[Msg.Success]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsgSuccess(final BigDecimal arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Normal: {0,number} units";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.Success");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenTwaProcessUtilMessages], key[Msg.Warning]
     *
     * [, Warning: {0,number} units] (en)<br>
     * [、警告: {0,number} 件] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.math.BigDecimal型を与えてください。
     * @return key[Msg.Warning]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsgWarning(final BigDecimal arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = ", Warning: {0,number} units";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.Warning");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenTwaProcessUtilMessages], key[Msg.Skipped]
     *
     * [, Skip: {0,number} units] (en)<br>
     * [、スキップ: {0,number} 件] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.math.BigDecimal型を与えてください。
     * @return key[Msg.Skipped]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsgSkipped(final BigDecimal arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = ", Skip: {0,number} units";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.Skipped");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenTwaProcessUtilMessages], key[Msg.Unit.Success]
     *
     * [Unit: {0,number} units] (en)<br>
     * [単位: {0,number} 件] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.math.BigDecimal型を与えてください。
     * @return key[Msg.Unit.Success]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsgUnitSuccess(final BigDecimal arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Unit: {0,number} units";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.Unit.Success");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }
}
