/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.cat.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

import benten.twa.BentenTwaConstants;
import benten.twa.cat.messages.BentenApplyExactMatchMessages;
import benten.twa.cat.status.BentenApplyExactMatchStatus;
import benten.twa.ui.dialogs.AbstractTmWorkflowDialog;
import benten.ui.UiStatus;
import benten.ui.UiStatusException;
import benten.ui.fields.ResourceFolderTextField;
import benten.ui.preference.BentenPreference;
import benten.ui.preference.BentenPreference.Preference;
import benten.ui.views.UiToolkit;

/**
 * 完全一致訳の適用
 *
 * <pre>
 * TMX の完全一致訳を XLIFF に適用します。
 *    1.  未翻訳の翻訳対象に対して訳の適用を試みます。
 *    2.  翻訳単位と完全一致する TMX を探し、翻訳単位に適用します。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳中間形式機械支援翻訳機能: 完全一致訳適用機能」に対応します。
 *
 * @author IGA Tosiki
 */
public class ApplyExactMatchDialog extends AbstractTmWorkflowDialog {
	/**
	 * 完全一致訳適用機能のためのメッセージ。
	 */
	protected static final BentenApplyExactMatchMessages fMsg = new BentenApplyExactMatchMessages();

	/**
	 * Benten が提供する基本的なウィジェットを生成する UI ツールキットのインスタンス。
	 */
	protected final UiToolkit toolkit = new UiToolkit();

	/** コントロール・コンテナー */
	private final ApplyExactMatchControls controls = new ApplyExactMatchControls();

	/** コントロール・コンテナー・クラス */
	public static class ApplyExactMatchControls {

		/** XLIFF ディレクトリー・テキスト */
		public ResourceFolderTextField xliffDirText;
	}

	/**
	 * コンストラクター。
	 * @param parentShell 親シェル
	 * @param selection 選択
	 */
	public ApplyExactMatchDialog(final Shell parentShell, final IStructuredSelection selection) {
		super(parentShell, selection, fMsg.getWindowTitle());
	}

	@Override
	public void createControls(final Composite composite) {
		composite.setLayout(new GridLayout(3, false));

		controls.xliffDirText = new ResourceFolderTextField(composite, fMsg.getDialogCtrlLabelXliffDir());
		controls.xliffDirText.addModifyListener(this);
		if (getSelectionResource() != null) {
			controls.xliffDirText.setText(getSelectionResource().getProject().getName()
					+ "/" + BentenTwaConstants.DEFAULT_XLIFF_DIR); //$NON-NLS-1$
		}
		createTmPreferenceArea(composite);
	}

	@Override
	public IStatus getResultStatus() {
		final BentenApplyExactMatchStatus status = new BentenApplyExactMatchStatus();
		status.setXliffDir(controls.xliffDirText.getFile());
		status.setProject(controls.xliffDirText.getResource());

		// benten.cat.tm.ui.CatTmUiPlugin#fuzzyMatch のプリファランス処理内容と関連性があります。
		final IPreferenceStore store = BentenPreference.getStore();
		status.setIgnoreWhitespaceTmReference(store.getBoolean(Preference.IGNORE_WHITESPACE_TM_REFERENCE.name()));
		status.setIgnoreMnemonicKeyTmReference(store.getBoolean(Preference.IGNORE_MNEMONIC_KEY_TM_REFERENCE.name()));
		return status;
	}

	@Override
	public IStatus validate() throws UiStatusException {
		validatePath(controls.xliffDirText);
		return UiStatus.OK_STATUS;
	}
}
