/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.xliff.handler;

import java.io.IOException;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.SAXException;

import benten.twa.ui.jobs.AbstractWorkflowHandler;
import benten.twa.xliff.core.BentenExtractXliffFragmentBatchProcess;
import benten.twa.xliff.core.BentenExtractXliffFragmentProcessImpl;
import benten.twa.xliff.core.valueobject.BentenExtractXliffFragmentProcessInput;
import benten.twa.xliff.dialogs.ExtractXliffFragmentDialog;
import benten.twa.xliff.messages.BentenExtractXliffFragmentMessages;
import benten.twa.xliff.status.BentenExtractXliffFragmentStatus;

/**
 * XLIFF フラグメント抽出ハンドラーです。
 * 
 * XLIFF フラグメントの抽出
 * 
 * <pre>
 * XLIFF から XLIFF フラグメントを抽出します。
 *   1.  XLIFF から所定の条件に合う翻訳単位を抽出して XLIFF フラグメントを作成します。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳中間形式断片抽出・マージ機能: XLIFFフラグメント抽出機能」に対応します。
 * 
 * @author KASHIHARA Shinji
 */
public class ExtractXliffFragmentHandler extends AbstractWorkflowHandler {
	/**
	 * XLIFF フラグメント抽出機能のためのメッセージ。
	 */
	protected static final BentenExtractXliffFragmentMessages fMsg = new BentenExtractXliffFragmentMessages();

	@Override
	protected StatusDialog createDialog(final Shell shell, final IStructuredSelection selection) {
		setJobMessage(fMsg.getJobName());
		return new ExtractXliffFragmentDialog(shell, selection);
	}

	@Override
	protected void processFile(final IStatus iStatus) throws IOException, SAXException {
		final BentenExtractXliffFragmentStatus status = (BentenExtractXliffFragmentStatus) iStatus;

		// このタスクは 1 ファイル対象なので、プログレス総数は固定値とします。
		monitor.beginTask(null, 20);

		final BentenExtractXliffFragmentProcessInput input = new BentenExtractXliffFragmentProcessInput();
		input.setSourcexlifffile(status.getFromXliffFile().getAbsolutePath());
		input.setTargetxliffdir(status.getToDir().getAbsolutePath());
		input.setExtractbystate(status.getState());
		if (status.getSizeLimit() >= 1) {
			input.setLimitsize(status.getSizeLimit());
		}
		input.setIncludedate(status.getIncludeDate());
		new BentenExtractXliffFragmentBatchProcess().validateInput(input);
		final BentenExtractXliffFragmentProcessImpl process = new BentenExtractXliffFragmentProcessImpl() {
			@Override
			public boolean progress(final String argProgressMessage) {
				monitor.subTask(argProgressMessage);
				monitor.worked(1);
				Thread.yield();
				return monitor.isCanceled();
			}
		};
		process.execute(input);
		resultInfo = process.getResultInfo();
	}
}
