/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.tm.engine.regex;

import benten.cat.tm.core.BentenTmDriver;
import benten.cat.tm.core.BentenTmDriverManager;
import benten.cat.tm.core.BentenTmEngine;

/**
 * このクラスは、TM エンジンの切り替えテストのためのテストクラスです。
 * 実際の Benten 基本セットには含まれません。
 * 
 * このクラスを Class.forName() すると、ドライバーが登録されます
 * 
 * @author IGA Tosiki
 */
public class RegexTmDriver implements BentenTmDriver {
	/**
	 * このエンジンのドライバー名。
	 */
	public static final String DRIVER_NAME = "regex"; //$NON-NLS-1$

	static {
		// 自分を登録。
		BentenTmDriverManager.registerDriver(new RegexTmDriver());
	}

	/**
	 * {@inheritDoc}
	 */
	public String getName() {
		return DRIVER_NAME;
	}

	/**
	 * {@inheritDoc}
	 */
	public BentenTmEngine getEngineInstance() {
		return new RegexTmEngine();
	}
}
