/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.tm.engine.regex.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.framework.BundleContext;

import benten.cat.tm.core.BentenTmDriver;
import benten.cat.tm.core.BentenTmDriverManager;
import benten.cat.tm.core.BentenTmEngine;
import benten.cat.tm.data.AbstractBentenTmDataTmxPlugin;
import benten.cat.tm.engine.AbstractBentenTmEnginePlugin;
import benten.cat.tm.engine.regex.RegexTmDriver;
import benten.cat.tm.engine.regex.ui.messages.RegexTmPluginMessages;
import benten.ui.preference.BentenPreference;
import benten.ui.preference.BentenPreference.Preference;

/**
 * このクラスは、TM エンジンの切り替えテストのためのテストクラスです。
 * 実際の Benten 基本セットには含まれません。
 * 
 * <UL>
 * <LI>このプラグインを Eclipse 上で有効化するためのプラグイン・クラスです。
 * </UL>
 * 
 * @author IGA Tosiki
 */
public class RegexTmPlugin extends AbstractBentenTmEnginePlugin {
	/** 共用インスタンス。 */
	private static RegexTmPlugin plugin;

	/**
	 * Benten 正規表現 (Regex) TM エンジン・プラグインのためのメッセージ。
	 */
	protected static final RegexTmPluginMessages fMsg = new RegexTmPluginMessages();

	@Override
	public void start(final BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	@Override
	public void stop(final BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	@Override
	public AbstractBentenTmEnginePlugin getPluginDefault() {
		return plugin;
	}

	@Override
	public BentenTmDriver getDriver() {
		try {
			// 自らのドライバーを自己登録します。
			Class.forName("benten.cat.tm.engine.regex.RegexTmDriver"); //$NON-NLS-1$
		} catch (final ClassNotFoundException e) {
			log("Fail to load Regex TM engine."); //$NON-NLS-1$
			log(e);
		}

		return BentenTmDriverManager.getDriver(RegexTmDriver.DRIVER_NAME);
	}

	@Override
	public BentenTmEngine getEngine() {
		if (fEngine == null) {
			fEngine = getDriver().getEngineInstance();
		}

		return fEngine;
	}

	@Override
	public void load() {
		getPluginDefault().log("Regex TM engine plug-in: Refresh load TM."); //$NON-NLS-1$

		getEngine().unload();

		for (File dir : getTmxDir()) {
			try {
				getEngine().loadTmx(dir);
			} catch (final IOException e) {
				getPluginDefault().log(e);
			}
		}
	}

	/**
	 * 拡張ポイントなどから TMX ディレクトリーを取得します。
	 * @return TMX ディレクトリー。必ず null 以外が戻ります。
	 */
	private File[] getTmxDir() {
		final List<File> result = new ArrayList<File>();

		final IPreferenceStore store = BentenPreference.getStore();
		final boolean useTmxLocation = store.getBoolean(Preference.USE_TMX_LOCATION.name());
		if (useTmxLocation) {
			final String tmxFolder = store.getString(Preference.TMX_LOCATION.name());
			final File dir = new File(tmxFolder);
			result.add(dir);
			getPluginDefault().log(fMsg.getGetTmxDirI001(dir.getAbsolutePath()));
		} else {
			for (AbstractBentenTmDataTmxPlugin plugin : getTmxDataPlugin()) {
				final File dir = plugin.getPluginDefault().getFile("/tmx"); //$NON-NLS-1$
				result.add(dir);
				getPluginDefault().log(fMsg.getGetTmxDirI001(dir.getAbsolutePath()));
			}
		}

		for (File dir : result) {
			if (dir.exists() == false) {
				throw new IllegalArgumentException(fMsg.getGetTmxDirE001(dir.getAbsolutePath()));
			}
			if (dir.isDirectory() == false) {
				throw new IllegalArgumentException(fMsg.getGetTmxDirE002(dir.getAbsolutePath()));
			}
		}

		return result.toArray(new File[result.size()]);
	}

	/**
	 * 拡張ポイントから TM データ TMX プラグインを取得します。
	 * @return TM データ TMX プラグイン。必ず null 以外が戻ります。
	 */
	private List<AbstractBentenTmDataTmxPlugin> getTmxDataPlugin() {
		final List<AbstractBentenTmDataTmxPlugin> result = new ArrayList<AbstractBentenTmDataTmxPlugin>();

		final IExtensionRegistry registry = Platform.getExtensionRegistry();
		final IExtensionPoint point = registry.getExtensionPoint("benten.cat.tm.data.tmx"); //$NON-NLS-1$

		if (point == null) {
			throw new IllegalArgumentException(fMsg.getGetTmxDataPluginE001());
		}

		for (IExtension extension : point.getExtensions()) {
			for (IConfigurationElement cfgElem : extension.getConfigurationElements()) {
				try {
					final Object tmxPluginClass = cfgElem.createExecutableExtension("class"); //$NON-NLS-1$
					if (tmxPluginClass instanceof AbstractBentenTmDataTmxPlugin) {
						result.add((AbstractBentenTmDataTmxPlugin) tmxPluginClass);
					}
				} catch (final CoreException e) {
					getPluginDefault().log(e);
				}
			}
		}
		return result;
	}
}
