/*******************************************************************************
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.tm.engine.simple;

import benten.cat.tm.core.BentenTmDriver;
import benten.cat.tm.core.BentenTmDriverManager;
import benten.cat.tm.core.BentenTmEngine;

/**
 * このクラスは、シンプル TM エンジンのドライバー・クラスです。
 * 
 * このクラスを Class.forName() すると、ドライバーが登録されます
 * 
 * @author IGA Tosiki
 * @author YAMAMOTO Koji
 */
public class SimpleTmDriver implements BentenTmDriver {
	/**
	 * このエンジンのドライバー名。
	 */
	public static final String DRIVER_NAME = "simple"; //$NON-NLS-1$

	static {
		// 自分を登録。
		BentenTmDriverManager.registerDriver(new SimpleTmDriver());
	}

	/**
	 * {@inheritDoc}
	 */
	public String getName() {
		return DRIVER_NAME;
	}

	/**
	 * {@inheritDoc}
	 */
	public BentenTmEngine getEngineInstance() {
		return new SimpleTmEngine();
	}
}
