/* The cheapest, quickest to write program I can make up to strip line numbers.
// The line number field is variable width and has optional leading whitespace.
// Written by Joel Rees, Takino, Hyogo, Japan, January 2000.
// Too Q&D to bother copyrighting, assigned to the public domain.
// Since it is in the public domain, it can't be copyrighted. 
// Your personal expression of it may be copyrightable, however.
//
// The changes in my programing style prove that I am turning Japanese.
// Current e-mail: joel_rees@sannet.ne.jp, reiisi@nettaxi.com
*/


/* #define ON_Macintosh */


#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>


#if defined ON_Macintosh
#	pragma		push
#	pragma		only_std_keywords off
#	include		<Types.h>
#	include		<Fonts.h>
#	pragma		pop
#endif


#if defined ON_Macintosh
#	include		<sioux.h>
#	include		<console.h>
#endif


#define BUFFERCHARS	1024
#define BUFFSIZE	( 1024 + 1 )	/* One shot, should be no lines this large anyway. */


int nocaseCompare( char * range, char * object )
{	int difference = 0
	while ( ( * object != '\0' ) && ( ( difference = ( toupper( * range++ ) - toupper( * object++ ) ) ) == 0 ) )
	{ /* empty loop */ }
	return difference;
}


char * nocaseScan( char * range, char * object )
{	char * inObject = object;
	if ( ( * range == '\0' ) || ( * object == '\0' ) )
	{	return NULL;
	}
	while ( ( * range != '\0' ) && ( toupper( * range ) != toupper( * inObject ) ) )	
	{	++range;
	}
	
	return range;
}


int main( int argc, char * argv[] )
{
	int ch;
	FILE * input = stdin;
	int fdbFlag = 0;
/* */
#	if defined ON_Macintosh
	{	Str31 name = "\pOsaka|";
		short familyID = 0;
	/* */
		GetFNum( name, &familyID );
		SIOUXSettings.fontsize = 12;
		SIOUXSettings.fontid = familyID;
		SIOUXSettings.showstatusline = 1;
		argc = ccommand( &argv );
	}
#	endif
	/* Use the pseudo-command-line as simple file interface
	// argc = ccommand( &argv ); 
	*/
	if ( argc > 1 )
	{	int arg;
		for ( arg = 1; arg < argc; ++arg )
		{	if ( ( argc == 2 ) || ( ( strcmp( argv[ arg ], "-f" ) == 0 ) && ( ++arg < argc ) ) )
			{	input = fopen( argv[ arg ], "rb" );
				if ( input == NULL )
				{	fprintf( stderr, "Failed to open %s\n", argv[ arg ] );
					return EXIT_FAILURE;
				}
			}
			else if ( strcmp( argv[ arg ], "-fdb" ) == 0 )
			{	fdbFlag = 1;
			}
			/* else if ( ( strcmp( argv[ arg ], "-e" ) == 0 ) && ( ++arg < argc ) )
			{
			} 
			*/
			else
			{	fprintf( stderr, "Unknown option #%d: %s\n", arg, argv[ arg ] );
			}
		}
	}
/* */
	while ( !feof( input ) )
	{
		char buffer[ BUFFSIZE ];
		char * scan = buffer;
		char * printpoint;
		char * label = NULL;
		buffer[ 0 ] = '\0';
		fgets( buffer, BUFFSIZE, input );
		while ( isspace( * scan++ ) )
		{	/* bit bucket */ }
		while ( isdigit( * scan++ ) )	/* Kill the line number. */
		{	/* bit bucket */ }
		while ( isspace( * scan++ ) )
		{	/* bit bucket */ }
		printpoint = scan;
		if ( fdbFlag )
		{
			if ( nocaseCompare( scan, "FDB" ) != 0 )
			{	label = scan; /* wrong */
				/* I need to find FDB anywhere on the line, and if there's a label in front of it, save the label. */
			}
			size_t chCount = 0;
			size_t labelMarker = 0;
			size_t opcodeMarker = 0;
			while ( ( ch = getc( input ) ) != EOF && isspace( ch ) && chCount < BUFSIZE )
			{	buffer[ chCount++ ] = (char) ch; 
			}
			labelMarker = opcodeMarker = chCount;
			while ( ch != EOF && isalnum( ch ) )
			{	buffer[ chCount++ ] = ch;
				ch = getc( input );
			}
			while ( ch != EOF && isspace( ch ) )
			{	buffer[ chCount++ ] = ch;
				ch = getc( input );
			}
			/* And I realize that I need to take care of labels in some reasonable manner.
			// Maybe put the label in a comment after the icode?.
			*/
			buffer[ chCount ] = '\0';
			fputs( buffer, stdout );
		}
		while ( ( ch = getc( input ) ) != EOF 
				&& ch != '\n' && ch != '\r' /* && ch != '\0' */ )
		{	putchar( ch );	/* Copy, but eoln type characters go to bit bucket. */
		}
		putchar( '\n' );	/* At one time, this was supposed to output full CR/LF on DOS. */
		/* Rather than try to figure out the intricacies of the end-of-file and end-of-line 
		// interaction, I am just letting an extra empty line be dumped to the output. 
		// The present application is not sensitive to such things.
		*/
	}
	return EXIT_SUCCESS;
}

