/*
**  bif4_a.h
**  bif-c
**
**  Created by Joel Rees on 2009/08/16.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF4/A, as mechanically as possible.
*/


#if !defined BIF4_A_H
#define BIF4_A_H


#include "bifu_i.h"


extern definition_header_s hMSTAR;
extern void MSTAR(void);

extern definition_header_s hMSLASH;
extern void MSLASH(void);

extern definition_header_s hSTAR;
extern void STAR(void);

extern definition_header_s hSLAMOD;
extern void SLAMOD(void);

extern definition_header_s hSLASH;
extern void SLASH(void);

extern definition_header_s hMOD;
extern void MOD(void);

extern definition_header_s hSSMOD;
extern void SSMOD(void);

extern definition_header_s hSTARSL;
extern void STARSL(void);

extern definition_header_s hMSMOD;
extern void MSMOD(void);

extern definition_header_s hADDBUF;
extern void ADDBUF(void);

extern definition_header_s hUPDATE;
extern void UPDATE(void);

extern definition_header_s hEMTBUF;
extern void EMTBUF(void);

/* Lots of implicit linkage here, see B/BUF, etc., too.
** Ultimately, this needs to be defined at the FORTH level, too.
*/
#define	DRIVE_SIZE	0	/* size limit (block count) */
#define	DRIVE_FILE	1	/* file pointer */
#define	DRIVE_MODE	2	/* as char array, "ro" | "rw" | "wo" */
#define	DRIVE_NAME	3	/* char * */
#define	DRIVE_ELEMENT_COUNT	4
#define	COCO_SINGLE	( 18 * 35 )
/* I keep thinking I want sector/block size here, instead, but maybe not really. */
typedef cell_u vdrive_a[ DRIVE_ELEMENT_COUNT ];	/* Structures are just arrays, right? 8-* */
#define DRIVE_LIST_TERMINATOR	CELL_HIGH_BIT

extern definition_header_s hDROFFS;

extern definition_header_s hDRIVE;
extern void DRIVE(void);

extern definition_header_s hRW;
extern void RW(void);


#endif /* !defined BIF4_A_H */
