<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		EntryList.class.php
 * @brief		エントリー一覧クラス
 * @date		2006.12.13
 */

require_once(CLASS_DIR."/PageRender.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");
require_once(CLASS_DIR."/adodb/CategoryManager.class.php");
require_once(CLASS_DIR."/adodb/EntryManager.class.php");

class EntryList extends PageRender
{
	function makePage()
	{
		$this->assign("TOPIC_PATH","<a href=\"./index.php?mode=3\">bitcube管理TOP</a> &gt; 記事一覧");
		
		if(count($_POST) > 0)
		{
			$_SESSION["page"]["1"][$_GET["group_code"]] = 1;
			$_SESSION["search"]["1"][$_GET["group_code"]] = array();
			
			$_SESSION["per_page"]["1"][$_GET["group_code"]] = $_POST["per_page"];
			$_SESSION["search"]["1"][$_GET["group_code"]]["category_code"] = $_POST["category_code"];
			$_SESSION["search"]["1"][$_GET["group_code"]]["search_word"] = preg_replace("/\s\s+/"," ",mb_convert_kana(trim($_POST["search_word"]),"s"));
		}
		
		$dao = new GroupManager();
		$group_array = $dao->getGroupList();
		if(!$group_array > 0)
			$this->error("更新セット情報の取得に失敗しました。");
		$this->assign("group_array",$group_array);
		
		$current_group = $dao->getGroupInfo($_GET["group_code"]);
		if(!$current_group)
			$this->error("更新セット情報の取得に失敗しました。");
		$this->assign("current_group",$current_group);
		
		$category_dao = new CategoryManager();
		$group_category_array = $category_dao->getCategoryList("$category_dao->category.category_code asc","$category_dao->category.group_code = ".$_GET["group_code"]);
		$this->assign("group_category_array",$group_category_array);
		
		$entry_dao = new EntryManager();
		
		if($_SESSION["search"]["1"][$_GET["group_code"]]["category_code"] == "0")
			$condition .= " and $entry_dao->entry.category_code = 0 ";
		else if(strlen($_SESSION["search"]["1"][$_GET["group_code"]]["category_code"]) > 0)
			$condition .= " and $entry_dao->entry.category_code = ".$_SESSION["search"]["1"][$_GET["group_code"]]["category_code"]." ";
		
		if($_SESSION["search"]["1"][$_GET["group_code"]]["search_word"])
			foreach(preg_split("/[\s]+/",trim($_SESSION["search"]["1"][$_GET["group_code"]]["search_word"])) as $search_word)
				$condition .= " and $entry_dao->entry.entry_title like ".$entry_dao->qstr("%".$search_word."%")." ";
		
		$group_entry_array = $entry_dao->getEntryList("$entry_dao->entry.entry_order desc","$entry_dao->entry.group_code = ".$_GET["group_code"].$condition,$_SESSION["per_page"]["1"][$_GET["group_code"]],$_SESSION["page"]["1"][$_GET["group_code"]]);
		$this->assign("group_entry_array",$group_entry_array->GetArray());
		$this->assign("current_page",$group_entry_array->AbsolutePage());
		$this->assign("first_page",$group_entry_array->AtFirstPage());
		$this->assign("last_page",$group_entry_array->AtLastPage());
		
		$entry_count = $entry_dao->getEntryCount("$entry_dao->entry.group_code = ".$_GET["group_code"].$condition);
		$this->assign("page_count",ceil($entry_count/$_SESSION["per_page"]["1"][$_GET["group_code"]]));
		
		$this->assign("category_code",$_SESSION["search"]["1"][$_GET["group_code"]]["category_code"]);
		$this->assign("per_page",$_SESSION["per_page"]["1"][$_GET["group_code"]]);
		$this->assign("search_word",$_SESSION["search"]["1"][$_GET["group_code"]]["search_word"]);
		
		$this->template = "EntryList.tpl";
	}
	
	function render()
	{
		$this->makePage();
		$this->renderPage();
	}
}
