<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		GeneralCategoryView.class.php
 * @brief		一般用カテゴリーページビュークラス
 * @date		2007.01.24
 */

require_once(CLASS_DIR."/ViewRender.class.php");
require_once(CLASS_DIR."/adodb/GeneralCategoryManager.class.php");

class GeneralCategoryView extends ViewRender
{
	function makeView()
	{
		$dao = new GeneralCategoryManager();
		$category = $dao->getCategoryInfo($_GET["group_code"],$_GET["category_code"]);
		if(!$category)
			$this->error("Not Found");
		
		$this->assignBitcubeTags($category["group_code"],$category["category_code"]);
		
		$this->register_resource("tpl");
		$this->template = "tpl:".$category["category_page_tmpl"];
	}
	
	function render()
	{
		$this->makeView();
		$this->renderView();
	}
}
