<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		GeneralNewsView.class.php
 * @brief		一般用ニュース詳細ページビュークラス
 * @date		2007.01.24
 */

require_once(CLASS_DIR."/ViewRender.class.php");
require_once(CLASS_DIR."/adodb/GeneralNewsManager.class.php");

class GeneralNewsView extends ViewRender
{
	function makeView()
	{
		$dao = new GeneralNewsManager();
		$news = $dao->getNewsInfo($_GET["group_code"],$_GET["entry_code"]);
		if(!$news)
			$this->error("Not Found");
		
		$this->assignBitcubeTags($news["group_code"],$news["category_code"],$news["entry_code"]);
		
		$this->register_resource("tpl");
		$this->template = "tpl:".preg_replace("/".preg_quote("<[$BCCurrentEntry.Body]>","/")."/",$news["entry_body"],$news["news_detail_tmpl"]);
	}
	
	function render()
	{
		$this->makeView();
		$this->renderView();
	}
}
