<?php
/* 
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		Import.class.php
 * @brief		インポートクラス
 * @date		2007.03.22
 */

require_once(CLASS_DIR."/form/ImportInputForm.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");
require_once(CLASS_DIR."/adodb/BitcubeDB.class.php");

class Import extends ImportInputForm
{
	function makeForm()
	{
		$this->assign("TOPIC_PATH","<a href=\"./index.php?mode=3\">bitcube管理TOP</a> &gt; インポート");
		
		$group_dao = new GroupManager();
		$group_array = $group_dao->getGroupList();
		$this->assign("group_array",$group_array);
		
		switch($_POST["state"])
		{
			case 1 :{$this->input();break;}		// 入力
			case 2 :{$this->confirm();break;}	// 確認
			case 3 :{$this->complete();break;}	// 完了
			default:{$this->input();break;}		// 入力
		}
	}
	
	// 入力
	function input()
	{
		$this->assign("state",2);
		$this->template = "ImportInput.tpl";
	}
	
	// 確認
	function confirm()
	{
		$this->setFileType($_FILES["file"]["type"]);
		$this->setFileSize($_FILES["file"]["size"]);
		$form_error_array = $this->check();
		
		if((count($form_error_array) > 0) || ($_POST["back"]))
		{
			if(($_POST["back"]) && ($_POST["file_name"]))
				system("rm -r \"".CACHE_DIR."/".$_POST["file_name"]."\" ");
			
			$this->assign("state",2);
			$this->assign("error_array",$form_error_array);
			$this->template = "ImportInput.tpl";
		}
		else
		{
			$file_name = session_id().".csv";
			
			if(!move_uploaded_file($_FILES["file"]["tmp_name"],CACHE_DIR."/".$file_name))
				$this->error("ファイルのアップロードに失敗しました。");
			
			$handle = fopen(CACHE_DIR."/".$file_name,"r");
			while(($data = fgetcsv($handle,2097152,",")) !== false)
				$total[$data["0"]]++;
			fclose($handle);
			
			$this->assign("state",3);
			$this->assign("file_name",$file_name);
			$this->assign("total",$total);
			$this->assign("message_array","下記の内容でインポートします。よろしければ「入力」ボタンを押してください。<br />修正をする場合は「変更」ボタンよりお戻りください。");
			$this->template = "ImportConfirm.tpl";
		}
	}
	
	// 完了
	function complete()
	{
		if($handle = fopen(CACHE_DIR."/".$_POST["file_name"],"r"))
		{
			$dao = new BitcubeDB();
			
			$dao->Execute("delete from ".$dao->group);
			$dao->Execute("delete from ".$dao->category);
			$dao->Execute("delete from ".$dao->entry);
			$dao->Execute("delete from ".$dao->template);
			$dao->Execute("delete from ".$dao->template_module);
			
			$dao->StartTrans();
			$dao->LockALL();
			
			while(($data = fgetcsv($handle,2097152,",")) !== false)
			{
				switch($data["0"])
				{
					case "group":
					{
						$table = $dao->group;
						$record["group_code"] = $data["1"];
						$record["group_regist_date"] = $data["2"];
						$record["group_modification_date"] = $data["3"];
						$record["group_name"] = $data["4"];
						$record["group_meta_description"] = $data[""];
						$record["group_meta_keyword"] = $data["6"];
						$record["group_dir_name"] = $data["7"];
						$record["group_upload_dir_name"] = $data["8"];
						$record["group_default_publish"] = $data["9"];
						$record["group_summary_strings_num"] = $data["10"];
						$record["group_rss_output_num"] = $data["11"];
						$record["group_rss1_output"] = $data["12"];
						$record["group_rss1_file_name"] = $data["13"];
						$record["group_rss2_output"] = $data["14"];
						$record["group_rss2_file_name"] = $data["15"];
						$record["group_atom_output"] = $data["16"];
						$record["group_atom_file_name"] = $data["17"];
						$record["group_rss_copyright"] = $data["18"];
						$record["group_rss_creator"] = $data["19"];
						$record["group_ping_other_sites"] = $data["20"];
						$record["is_delete"] = $data["21"];
						break;
					}
					case "category":
					{
						$table = $dao->category;
						$record["category_code"] = $data["1"];
						$record["group_code"] = $data["2"];
						$record["category_name"] = $data["3"];
						$record["category_order"] = $data["4"];
						$record["is_delete"] = $data["5"];
						break;
					}
					case "entry":
					{
						$table = $dao->entry;
						$record["entry_code"] = $data["1"];
						$record["group_code"] = $data["2"];
						$record["category_code"] = $data["3"];
						$record["entry_regist_date"] = $data["4"];
						$record["entry_modification_date"] = $data["5"];
						$record["entry_date"] = $data["6"];
						$record["entry_publish"] = $data["7"];
						$record["entry_title"] = $data["8"];
						$record["entry_body"] = $data["9"];
						$record["entry_order"] = $data["10"];
						$record["entry_page_view"] = $data["11"];
						$record["is_delete"] = $data["12"];
						break;
					}
					case "template":
					{
						$table = $dao->template;
						$record["group_code"] = $data["1"];
						$record["top_page_tmpl"] = $data["2"];
						$record["category_page_tmpl"] = $data["3"];
						$record["news_detail_tmpl"] = $data["4"];
						$record["rss1_tmpl"] = $data["5"];
						$record["rss2_tmpl"] = $data["6"];
						$record["atom_tmpl"] = $data["7"];
						$record["base_css_tmpl"] = $data["8"];
						$record["bitcube_css_tmpl"] = $data["9"];
						$record["bitcube_ie5win_tmpl"] = $data["10"];
						$record["is_delete"] = $data["11"];
						break;
					}
					case "template_module":
					{
						$table = $dao->template_module;
						$record["module_code"] = $data["1"];
						$record["group_code"] = $data["2"];
						$record["module_name"] = $data["3"];
						$record["module_file_name"] = $data["4"];
						$record["module_body"] = $data["5"];
						$record["is_delete"] = $data["6"];
						break;
					}
				}
				
				$dao->ExecuteInsert($table,$record);
			}
			fclose($handle);
			
			if(!$dao->CompleteTrans())
				$this->error("インポートに失敗しました。");
			
			system("rm -r \"".CACHE_DIR."/".$_POST["file_name"]."\" ");
			
			$_POST["state"] = 1;
			$this->assign("message_array","インポートが完了しました。");
			
			$this->makeForm();
		}
		else
		{
			$this->error("インポートに失敗しました。");
		}
	}
	
	function render()
	{
		$this->makeForm();
		$this->renderPage();
	}
}
